<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							xmlns:docbook="http://docbook.org/ns/docbook"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys docbook resolver">

    <xsl:import href="plugin:web://stylesheets/content/article/article-main.xsl"/>   
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
	
	<xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <a class="display-articles-section-item" href="{resolver:resolve('page', $page-id, false)}">
            <i class="fas fa-caret-right" aria-hidden="true"></i>
            <div> 
                <xsl:call-template name="content-title"/>
                <xsl:call-template name="content-abstract"/>
            </div>
        </a>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h2 class="title">
            <xsl:value-of select="metadata/title"/>
        </h2>
    </xsl:template>
	
	<xsl:template name="content-abstract">
        <xsl:param name="maxLength">150</xsl:param>
        
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">excerpt</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="$maxLength" />
        </xsl:call-template>
    </xsl:template>
	
</xsl:stylesheet>
