<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
     -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver">
                              
    <xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-newsletter.xsl"/>
    
    <xsl:template name="common-content-body-content">
        <td class="td-text">
          <table border="0" cellpadding="0" cellspacing="0" width="100%"  class="emailBlockActuText">
              <tr>
                  <td valign="top">
                        <xsl:call-template name="common-content-body-title-content"/>
                           
                        <!-- Abstract -->
                        <xsl:call-template name="common-content-body-simpletext">
                            <xsl:with-param name="css-class-name">content-abstract</xsl:with-param>
                            <xsl:with-param name="text" select="metadata/abstract" />
                            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
                            <xsl:with-param name="maxDefaultTextSize" select="120" />
                        </xsl:call-template>
                
                        <xsl:call-template name="common-content-body-readmore-newsletter"/>
                    </td>
                </tr>
            </table>
        </td>
    </xsl:template>
    
</xsl:stylesheet>
