<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
            	xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common" 
                exclude-result-prefixes="ametys docbook resolver exslt">    
    
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>

    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <a class="item" href="{resolver:resolve('page', $page-id, false)}" aria-label="{metadata/title}">
            <div class="infos"> 
                <xsl:call-template name="content-dates"/>
                <xsl:call-template name="content-title"/>
                <xsl:call-template name="content-abstract"/>
            </div>
            <xsl:call-template name="content-image"/>
        </a>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <xsl:if test="metadata/start-date != '' or metadata/end-date != ''">
            <div class="date-container">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/start-date"/>
                    <xsl:with-param name="endDate" select="metadata/end-date"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h3 class="title">
            <xsl:value-of select="metadata/title"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:param name="maxLength">115</xsl:param>
        
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">excerpt trunk3</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="$maxLength" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="content-image">
        <div class="img-container">
            <xsl:call-template name="content-tag"/>
            
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <xsl:variable name="image" select="metadata/illustration/image"/>
                    <picture>
                        <picture>
                            <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, 238, 320)}" media="(max-width: 360px)" />
                            <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, 529, 710)}" media="(max-width: 750px)" />
                            <img src="{resolver:resolveCroppedImage($image/@type, $image/@uri, 395, 510)}" alt="{metadata/illustration/alt-text}" />
                        </picture>
                    </picture>
                </xsl:when>
                <xsl:otherwise>
                    <img src="{ametys:skinURL('templates/common/img/image/img-pattern.jpg')}" max-width="510" height="395"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>    
    </xsl:template>
    
    <xsl:template name="content-tag">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:for-each select="exslt:node-set($tags)/tag[position() &lt;= 1]">
           <span class="tag">
                <xsl:if test="$useTagColor and @bgColor">
                    <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                </xsl:if>
                <xsl:value-of select="." />
           </span>
        </xsl:for-each>
     </xsl:template>
     
    <!-- Template used to display the content illustration -->
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth" select="'300'"/>
        <xsl:param name="maxHeight" select="'300'"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <img alt="{$alternative}">
                <xsl:attribute name="src">
                    <xsl:choose>
                        <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </img>
        </xsl:if>        
    </xsl:template>  
    
    <!-- Illustration big size -->
    <xsl:template name="common-content-body-image-bigsize">
        <xsl:param name="image" select="metadata/illustration/image"/>
        <xsl:param name="alternative" select="metadata/illustration/alt-text"/>
        <xsl:param name="maxWidth" select="'510'"/>
        <xsl:param name="maxHeight" select="'395'"/>
        <xsl:param name="class" select="'big'"/>
        <xsl:param name="type" select="'bounded'"/>
        
        <xsl:call-template name="common-content-body-image">
            <xsl:with-param name="image" select="$image"/>
            <xsl:with-param name="alternative" select="$alternative"/>
            <xsl:with-param name="maxWidth" select="$maxWidth"/>
            <xsl:with-param name="maxHeight" select="$maxHeight"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="type" select="$type"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="date-separator">
        <span><xsl:text> - </xsl:text></span>
    </xsl:template>

</xsl:stylesheet>    