<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="ametys resolver">    
    
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
    
    <xsl:template name="common-content-body">
	    <xsl:call-template name="common-content-body-title"/>
	    
	    <xsl:call-template name="common-content-body-content"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:call-template name="content-image"/>
            <div class="infos">
                <xsl:if test="not(metadata/illustration/image)">
                    <xsl:attribute name="class">infos no-picture</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="content-title"/>
                
                <xsl:call-template name="content-icon"/>
            </div>
        </a>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:if test="metadata/illustration/image">
	        <div class="picture">
                <xsl:call-template name="common-content-body-image-bigsize">
                    <xsl:with-param name="maxWidth" select="'218'"/>
                    <xsl:with-param name="maxHeight" select="'166'"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-icon">
        <span class="icon">
            <xsl:call-template name="ctype-icon"/>
        </span>
    </xsl:template>
    
    <xsl:template name="ctype-icon"/>
    
        <!-- Template used to display the content illustration -->
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth" select="'218'"/>
        <xsl:param name="maxHeight" select="'166'"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <picture>
                <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, '166', '414')}" media="(max-width: 414px)" />
                <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, '166', '470')}" media="(max-width: 550px)" />
                <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, '166', '305')}" media="(max-width: 1024px)" />
                <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, '140', '313')}" media="(max-width: 1050px)" />
                <source srcset="{resolver:resolveCroppedImage($image/@type, $image/@uri, '140', '180')}" media="(max-width: 1480px)" />
                <img src="{resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)}" alt="" />
            </picture>
        </xsl:if>        
    </xsl:template>
    
</xsl:stylesheet>