<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                              xmlns:stringutils="org.apache.commons.lang.StringUtils"
                              extension-element-prefixes="cms" 
                              exclude-result-prefixes="docbook resolver ametys stringutils">
                              
    <xsl:import href="skin://stylesheets/content/document/document.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">document view-main</xsl:variable>
    
    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
	    <div class="documents">
	      	<div class="document">
                <xsl:if test="not($zone = 'default')">
                    <xsl:call-template name="document-title"/>
                </xsl:if>
	      		<div class="flex-doc">
	      			<xsl:call-template name="document-icon"/>
	      			<xsl:call-template name="document-text"/>
	      			<xsl:call-template name="document-actions"/>
	          	</div>
          	</div>
         </div>
        
        <xsl:call-template name="common-content-body-content-rich"/>
    </xsl:template>
    
    <xsl:template name="document-title">
        <span class="document-title ametys-richtext-title-2 red"><xsl:value-of select="metadata/title"/></span>
    </xsl:template>
    
    <xsl:template name="document-icon">
        <xsl:call-template name="file-icon">
            <xsl:with-param name="filename" select="metadata/file/@filename"/>
            <xsl:with-param name="altWithExtension">true</xsl:with-param>
        </xsl:call-template>       
    </xsl:template>
    
    <xsl:template name="document-text">
        <div class="descri">
            <xsl:choose>
                <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="document-actions">
        <div class="actions">
            <xsl:call-template name="document-download"/>
            <xsl:call-template name="document-preview"/>
        </div>
    </xsl:template>
    
    <xsl:template name="document-download">
        <xsl:variable name="size">
            <xsl:call-template name="format-size-in-attribute">
                <xsl:with-param name="size" select="metadata/file/@size"></xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="i18nparams"><filename><xsl:value-of select="metadata/file/@filename"/></filename><size><xsl:value-of select="$size"/></size></xsl:variable> 
        
        <a href="{resolver:resolve(metadata/file/@type, metadata/file/@path, 'true')}" class="first-link">
            <xsl:attribute name="title">
                <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_DOWNLOAD_TITLE_WITH_SIZE'), $lang, $i18nparams)"/>
            </xsl:attribute>
            <xsl:attribute name="aria-label">
                <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_DOWNLOAD_TITLE_WITH_SIZE'), $lang, $i18nparams)"/>
            </xsl:attribute>
            <span class="icon-container">
                <xsl:call-template name="download-icon"/>
            </span>
            <span class="text"><i18n:text i18n:key="SKIN_DOCUMENT_DOWNLOAD" i18n:catalogue="skin.{$skin}"/></span>
        </a>
     </xsl:template>
     
     <xsl:template name="document-preview">
        <xsl:variable name="i18nparams"><filename><xsl:value-of select="metadata/file/@filename"/></filename></xsl:variable> 
     	<xsl:if test="metadata/file/@type and metadata/file/@mime-type = 'application/pdf'">
          <a href="{resolver:resolve(concat(metadata/file/@type, '-flipbook'), metadata/file/@path)}" class="first-link" target="_blank">
            <xsl:attribute name="title">
                <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_SEE_TITLE'), $lang, $i18nparams)"/>
            </xsl:attribute>
            <span class="icon-container">
	            <xsl:call-template name="preview-icon"/>
	        </span>
	        <span class="text"><i18n:text i18n:key="SKIN_DOCUMENT_SEE" i18n:catalogue="skin.{$skin}"/></span>
          </a>
        </xsl:if>
     </xsl:template>
     
     <xsl:template name="download-icon">
        <svg aria-hidden="true" version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
            <g id="Solid">
                <path d="M239,385c9.4,9.4,24.6,9.4,33.9,0c0,0,0,0,0,0l90.5-90.5c9.4-9.4,9.4-24.6,0-33.9c-9.4-9.4-24.6-9.4-33.9,0L280,310.1V48
            c0-13.3-10.7-24-24-24c-13.3,0-24,10.7-24,24v262.1l-49.5-49.5c-9.4-9.4-24.6-9.4-33.9,0c-9.4,9.4-9.4,24.6,0,33.9L239,385z" fill="#dd434f"></path>
                <path d="M464,232c-13.3,0-24,10.7-24,24v184H72V256c0-13.3-10.7-24-24-24s-24,10.7-24,24v192c0,22.1,17.9,40,40,40h384
            c22.1,0,40-17.9,40-40V256C488,242.7,477.3,232,464,232z" fill="#dd434f"></path>
            </g>
        </svg>
     </xsl:template>
     
     <xsl:template name="preview-icon">
        <svg aria-hidden="true" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
            <g><g><path d="M497,55.6c-56.5,0-103-25.6-156.5-18.3c-29.8,4.1-56.9,17.7-84.5,42.6c-27.6-24.9-54.7-38.5-84.5-42.6
                C118,30,71.5,55.6,15,55.6c-8.3,0-15,6.7-15,15c0,6.3,0,340.5,0,360c0,8.3,6.7,15,15,15c36,0,67-6.9,91.5-12.2
                c49.4-10.9,62.7-13.8,97.2,21c28.7,28.8,76,28.8,104.6,0c34.6-34.8,47.8-31.8,97.2-21l0.1,0c23.3,5.2,55.2,12.2,91.3,12.2
                c8.3,0,15-6.7,15-15c0-11.5,0-352.3,0-360C512,62.3,505.3,55.6,497,55.6z M30,85.1c83.6-5.5,134.6-51,211,21.8v260.6
                c-22.5-17.1-45.1-26.8-69.5-30.2C122.8,330.6,80,351.3,30,355V85.1z M482,415.2c-58.6-3.4-99-23.7-134.7-18.1
                c-20.1,3.1-38.2,13.9-60.2,36.1c-16.9,17-45.1,17.1-62.1,0c-22.1-22.2-40.1-33-60.2-36.1C129,391.5,88.9,411.7,30,415.2v-30.1
                c85.4-5.6,136.5-52.8,215.4,26.1c5.9,5.9,15.4,5.8,21.2,0c78.9-78.9,130-31.7,215.4-26.1V415.2z M482,355
                c-50-3.8-92.8-24.4-141.5-17.7c-24.4,3.4-47,13.1-69.5,30.2V106.9c76.4-72.9,127.4-27.3,211-21.8V355z"></path></g></g>
            <g><g><path d="M205.1,145.5c-17.5-13.4-34.1-19.4-53.6-19.4c-15.2,0-31.2,3.5-51.4,8l-0.2,0.1c-8.1,1.8-17.3,3.8-26.7,5.6
                c-8.1,1.6-13.5,9.4-11.9,17.5c1.6,8.1,9.4,13.5,17.5,11.9c30-5.7,55-13.1,72.7-13.1c12.8,0,23.1,3.8,35.3,13.2
                c6.6,5,16,3.8,21-2.8C212.9,159.9,211.7,150.5,205.1,145.5z"></path></g></g>
            <g><g><path d="M205.1,205.5c-17.5-13.4-34.1-19.4-53.6-19.4c-22,0-47.5,7.8-78.3,13.7c-8.1,1.6-13.5,9.4-11.9,17.5
                c1.6,8.1,9.4,13.5,17.5,11.9c30.3-5.8,54.9-13.1,72.7-13.1c12.8,0,23.1,3.8,35.3,13.2c6.6,5,16,3.8,21-2.8
                C212.9,219.9,211.7,210.5,205.1,205.5z"></path></g></g>
            <g><g><path d="M205.1,265.5c-17.5-13.4-34.1-19.4-53.6-19.4c-22,0-47.5,7.8-78.3,13.7c-8.1,1.5-13.5,9.4-11.9,17.5
                c1.5,8.1,9.4,13.5,17.5,11.9c30-5.7,55-13.1,72.7-13.1c12.8,0,23.1,3.8,35.3,13.2c6.6,5,16,3.8,21-2.8
                C212.9,279.9,211.7,270.5,205.1,265.5z"></path></g></g>
            <g><g><path d="M438.8,139.7c-31.1-5.9-56.2-13.7-78.3-13.7c-19.5,0-36,6-53.6,19.4c-6.6,5-7.8,14.5-2.8,21c5,6.6,14.5,7.8,21,2.8
                c12.3-9.4,22.5-13.2,35.3-13.2c17.8,0,42.7,7.4,72.7,13.1c8.1,1.5,16-3.8,17.5-11.9C452.3,149.1,446.9,141.3,438.8,139.7z"></path></g></g>
            <g><g> <path d="M438.8,199.7c-31.1-5.9-56.2-13.7-78.3-13.7c-19.5,0-36,6-53.6,19.4c-6.6,5-7.8,14.5-2.8,21c5,6.6,14.5,7.8,21,2.8
                c12.3-9.4,22.5-13.2,35.3-13.2c17.8,0,42.7,7.4,72.7,13.1c8.1,1.5,16-3.8,17.5-11.9C452.3,209.1,446.9,201.3,438.8,199.7z"></path></g></g>
            <g> <g><path d="M438.8,259.7c-31.1-5.9-56.2-13.7-78.3-13.7c-19.5,0-36,6-53.6,19.4c-6.6,5-7.8,14.5-2.8,21c5,6.6,14.5,7.8,21,2.8
                c12.3-9.4,22.5-13.2,35.3-13.2c17.8,0,42.7,7.4,72.7,13.1c8.1,1.5,16-3.8,17.5-11.9C452.3,269.1,446.9,261.3,438.8,259.7z"></path></g></g>
        </svg>
     </xsl:template>
    
</xsl:stylesheet>