<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="skin://stylesheets/meteo.xsl" />
    <xsl:import href="plugin:welcome-tour?://stylesheets/helper.xsl"/>
		
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_home.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <xsl:call-template name="head-tour-css"/>
    </xsl:template>
    
    <xsl:template name="head-tour-css">
        <xsl:if test="$tourEnabled">
            <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/tour/scss/main.css')}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <xsl:call-template name="head-tour-js"/>
    </xsl:template>
    
    <xsl:template name="head-tour-js">
        <xsl:call-template name="welcome-tour-js"/>
        <xsl:if test="$tourEnabled">
            <script type="text/javascript" src="{ametys:skinURL('templates/common/js/tour-transitions.js')}"></script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="header-class">
        <xsl:attribute name="class">header box-shadow</xsl:attribute>
    </xsl:template> 
    
	<xsl:template name="main-zone">
        <main role="main" id="main-content">
            <xsl:call-template name="main-top"/>
    			
    		<xsl:call-template name="home-links"/>
    				
    		<xsl:call-template name="zones"/>	
        </main>	
	</xsl:template>
    
    <xsl:template name="main-top">
        <div class="top-section">
            <div class="container">
                <div class="flex">
                   <!-- Welcome -->
                   <xsl:call-template name="welcome"/> 
                   <!-- Meteo -->
                   <xsl:call-template name="meteo-widget"/>
                </div>
    
                <div class="flex">
                    <!-- Main zone (carousel) -->
                    <div class="left">
                        <zone name="default" level="1"/>
                    </div>
                    
                    <!-- Quick access -->
                    <xsl:call-template name="quick-access"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="welcome">
        <h1>
            <i18n:text i18n:key="SKIN_HOME_WELCOME" i18n:catalogue="skin.{$skin}"/>
            <u><xsl:value-of select="$user/user/firstname"/></u>
        </h1>
    </xsl:template>
    
    <xsl:template name="zones">
        <xsl:call-template name="zone-bottom-1"/>
        <xsl:call-template name="zone-bottom-2"/>
        <xsl:call-template name="zone-bottom-3"/>        
        <xsl:call-template name="zone-bottom-4"/>
    </xsl:template>
    
    <xsl:template name="zone-bottom-1">
        <div data-ametys-zone="documents" id="ametys-cms-zone-documents" class="documents-section with-bg">
            <div class="container">
                <zone name="bottom-1" level="2"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="zone-bottom-2">
        <div data-ametys-zone="kiosque" id="ametys-cms-zone-kiosque" class="no-bg">
            <div class="container">
                <zone name="bottom-2" level="2"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="zone-bottom-3">
        <div class="mobilily-user with-bg" data-ametys-zone="directory" id="ametys-cms-zone-mobility-user">
            <div class="flex">
                <div class="left">
                    <div class="container">
                        <zone name="bottom-3-left" level="2"/>
                    </div>
                </div>
                <div class="right">
                    <zone name="bottom-3-right" level="2"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="zone-bottom-4">
        <div class="directory-section no-bg" data-ametys-zone="directory" id="ametys-cms-zone-directory">
             <div class="container">
                <zone name="bottom-4" level="2"/>
            </div>
        </div>
    </xsl:template>
	
    <!-- +
         | HOME LINKS
         + -->
    <xsl:template name="home-links">
        <xsl:choose>
            <xsl:when test="/cms/inputData/linkDirectory[@id='home']/links/link[not(@disabled)]">
                <div class="second-nav" id="ametys-cms-zone-second-nav">
                    <div class="container">
                        <ul>
                            <xsl:if test="count(/cms/inputData/linkDirectory[@id='home']/links/link[not(@disabled)]) &lt; 3">
                                <xsl:attribute name="class">space-evenly</xsl:attribute>
                            </xsl:if>
                            <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='home']/links/link[not(@disabled)]" mode="home-link"/>
                        </ul>
                    </div>
                </div>
            </xsl:when>
            <xsl:when test="$rendering-context = 'back'">
                <div class="second-nav" id="ametys-cms-zone-second-nav">
                    <div class="container">
                        <span class="empty-hint"><i18n:text i18n:key="SKIN_HOME_LINKS_BO_EMPTY" i18n:catalogue="skin.{$skin}"/></span>
                    </div>
                </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
	
    <xsl:template match="link[@urlType='PAGE']" mode="home-link">
        <li>
            <a href="{resolver:resolve('page', @url)}">
                <xsl:apply-templates select="." mode="home-link-icon"/>
                <xsl:apply-templates select="." mode="home-link-title"/>
            </a>
       </li>
     </xsl:template>
     
     <xsl:template match="link" mode="home-link">  
        <li>                            
            <a href="{@url}" target="_blank">
                <xsl:apply-templates select="." mode="home-link-icon"/>
                <xsl:apply-templates select="." mode="home-link-title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="home-link-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
                <span class="picture link-glyph {@pictureGlyph}"></span>
            </xsl:when>
            <xsl:when test="@pictureType != ''">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Do not use 'svg' class here because svgconvert.js does npt work for multicolor SVG -->
                <img src="{resolver:resolveBoundedImage(@imageType, $id, 50, 50)}" alt="{@pictureAlternative}"/>
            </xsl:when>
            <xsl:otherwise>
                <img class="svg" src="{ametys:skinURL('templates/common/img/image/img-pattern.jpg')}" max-width="50" height="50"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="link" mode="home-link-title">
        <span class="link">
            <xsl:value-of select="@title"/>
        </span>
    </xsl:template>
</xsl:stylesheet>