(function () {
  document.addEventListener('DOMContentLoaded', () => {
    setTimeout(() => {
      // Gestion de la sidebar mobile
      const mobileSidebar = document.querySelector('.search-page .sidebar');
      const mobileFilterBtn = document.querySelector('.btn-mobile-filters');
      const sidebarOverlay = document.querySelector('.sidebar-overlay');

      if (mobileFilterBtn && mobileSidebar && sidebarOverlay) {
        // Ouvrir la sidebar
        mobileFilterBtn.addEventListener('click', () => {
          mobileSidebar.classList.add('sidebar-open');
          sidebarOverlay.classList.add('active');
          document.body.style.overflow = 'hidden';
        });

        // Fermer la sidebar en cliquant sur l'overlay
        sidebarOverlay.addEventListener('click', () => {
          mobileSidebar.classList.remove('sidebar-open');
          sidebarOverlay.classList.remove('active');
          document.body.style.overflow = '';
        });

        // Fermer la sidebar avec la touche Escape
        document.addEventListener('keydown', (e) => {
          if (e.key === 'Escape' && mobileSidebar.classList.contains('sidebar-open')) {
            mobileSidebar.classList.remove('sidebar-open');
            sidebarOverlay.classList.remove('active');
            document.body.style.overflow = '';
          }
        });
      }
    }, 500);
  });
})();
