(function () {
  function waitForElm(selector, { timeout = 10000 } = {}) {
    return new Promise((resolve, reject) => {
      const found = document.querySelector(selector);
      if (found) return resolve(found);

      const obs = new MutationObserver(() => {
        const el = document.querySelector(selector);
        if (el) {
          obs.disconnect();
          resolve(el);
        }
      });

      obs.observe(document.documentElement, { childList: true, subtree: true });

      if (timeout) {
        setTimeout(() => {
          obs.disconnect();
          reject(new Error(`Timeout: ${selector} introuvable`));
        }, timeout);
      }
    });
  }

  function boot() {
    try {
      //await waitForElm(".carousel");

      $j(".carousel .carousel__list").slick({
        regionLabel: "actualités",
        infinite: true,
        autoplay: false,
        dots: true,
        pauseOnDotsHover: true,
        arrows: true,
        slidesToShow: 4,
        slidesToScroll: 4,
        ametysDotsBtnPrefixLabel: "Diapositive d'actualité ",
        appendArrows: $(".carousel-nav-wrapper"),
        appendDots: $(".carousel-nav-wrapper"),
          prevArrow: `
    <button type="button" class="slick-prev">
<svg xmlns="http://www.w3.org/2000/svg" width="8" height="14" viewBox="0 0 8 14" fill="none">
  <path d="M7 1L2 7L7 13" stroke="#153477" stroke-width="2"/>
  <path d="M7 1L2 7L7 13" stroke="url(#paint0_linear_5562_6415)" stroke-width="2"/>
  <defs>
    <linearGradient id="paint0_linear_5562_6415" x1="7" y1="7" x2="2" y2="7" gradientUnits="userSpaceOnUse">
      <stop stop-color="white" stop-opacity="0.8"/>
      <stop offset="1" stop-color="white" stop-opacity="0.8"/>
    </linearGradient>
  </defs>
</svg>
    </button>
  `,
  nextArrow: `
    <button type="button" class="slick-next">
   <svg xmlns="http://www.w3.org/2000/svg" width="8" height="14" viewBox="0 0 8 14" fill="none">
  <path d="M1 13L6 7L0.999999 1" stroke="#521C7E" stroke-width="2"/>
</svg>
    </button>
  `,
        customPaging: function (slider, i) {
          return '<button type="button"></button>';
        },
        responsive: [
          {
            breakpoint: 1200,
            settings: {
              slidesToShow: 3,
              slidesToScroll: 3,
            },
          },
          {
            breakpoint: 700,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 2,
            },
          },
          {
            breakpoint: 500,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1,
            },
          },
        ],
      });


const openBtnCarousel = document.querySelector(".carousel-popup__btn");
const popupCarousel = document.querySelector(".carousel-popup");
const closeBtnCarousel = popupCarousel.querySelector(".carousel-popup__close");

const focusableSelectorsCarousel =
  'a[href], button:not([disabled]), textarea, input, select, [tabindex]:not([tabindex="-1"])';
let lastFocusedElementCarousel = null;

function openPopupCarousel() {
  lastFocusedElementCarousel = document.activeElement;

  popupCarousel.setAttribute("aria-hidden", "false");
  popupCarousel.style.display = "block";

  const focusable = popupCarousel.querySelectorAll(focusableSelectorsCarousel);
  if (focusable.length) focusable[0].focus();

  document.addEventListener("keydown", trapFocusCarousel);
  document.addEventListener("keydown", handleEscCarousel);
}

function closePopupCarousel() {
  popupCarousel.setAttribute("aria-hidden", "true");
  popupCarousel.style.display = "none";

  if (lastFocusedElementCarousel) lastFocusedElementCarousel.focus();

  document.removeEventListener("keydown", trapFocusCarousel);
  document.removeEventListener("keydown", handleEscCarousel);
}

function handleEscCarousel(e) {
  if (e.key === "Escape") {
    closePopupCarousel();
  }
}

function trapFocusCarousel(e) {
  if (e.key !== "Tab") return;

  const focusable = popupCarousel.querySelectorAll(focusableSelectorsCarousel);
  const first = focusable[0];
  const last = focusable[focusable.length - 1];

  if (e.shiftKey) {
    if (document.activeElement === first) {
      e.preventDefault();
      last.focus();
    }
  } else {
    if (document.activeElement === last) {
      e.preventDefault();
      first.focus();
    }
  }
}

openBtnCarousel.addEventListener("click", openPopupCarousel);
closeBtnCarousel.addEventListener("click", closePopupCarousel);


    } catch (e) {
      console.warn(e.message);
    }
  }

  /*if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoadead", boot, { once: true });
  } else {
    boot();
  }*/
  
  $j(() => boot())
})();
