var AmetysResultMap = {
	
	POPUP_BASE_CLS_PREFIX: 'ametys-search-map-popup',
	
	SEARCH_MAP_DIALOG_OVERLAY_SELECTOR: '[data-search-map-dialog-overlay]', 
	SEARCH_MAP_DIALOG_SELECTOR: '[data-search-map-dialog]', 
	SEARCH_MAP_SELECTOR: '[data-search-map]', 
	SEARCH_MAP_DIALOG_INVOKER: '[data-search-map-dialog-invoker]', 
	
	map: null,
	results: [],
	markers: {},
	
	$invokerEl: null,
	$dialogEl: null,
	$overlayEl: null,
	$closeEl: null,
	
	initialize: function(results)
	{
		AmetysResultMap.markers = {};
		AmetysResultMap.map = null;
		
		// Group results (one marker for each results with same point)
        for (var i in results)
        {
            var result = results[i];
            var markers = result.markers || [];
            if (markers.length > 0)
            {
                for (var j in markers)
                {
                    var lat = markers[j].lat;
                    var lng = markers[j].lng;
                    var key = lat + '-' + lng;
                    
                    if (!AmetysResultMap.markers[key])
                    {
                        AmetysResultMap.markers[key] = {
                            lat: lat,
                            lng: lng,
                            results: []
                        }
                    }
                    AmetysResultMap.markers[key].results.push(result);
                }
            }
        }
		
		this._buildPopups();
		
		this.$invokerEl = $j(this.SEARCH_MAP_DIALOG_INVOKER);
		this.$dialogEl = $j(this.SEARCH_MAP_DIALOG_SELECTOR);
		this.$overlayEl = $j(this.SEARCH_MAP_DIALOG_OVERLAY_SELECTOR);
		this.$closeEl = this.$dialogEl.find('.close');
		
		this.$invokerEl.on('click', () => { this._showResultMap() });
		this.$overlayEl.on('click', () => { this._hideResultMap() });
		this.$closeEl.on('click', () => { this._hideResultMap() });
	},
	
	_buildPopups: function () {
	  
        var $popupBaseCls = this.POPUP_BASE_CLS_PREFIX,
            $itemBaseCls = this.POPUP_BASE_CLS_PREFIX + '__item',
            $listBaseCls = this.POPUP_BASE_CLS_PREFIX + '-list';
    
        for (var i in AmetysResultMap.markers)
        {
            var marker = AmetysResultMap.markers[i];
            if (marker.results.length > 1)
            {
                marker.text = marker.results.length;
                
                var html = '<div class="' + $popupBaseCls + '">';
                html += '<ul class="' + $listBaseCls + '">';
                for (var j in marker.results)
                {
                    var result = marker.results[j];
                    html += '<li class="' + $listBaseCls + '__item">';
                    html += '<a class="' + $listBaseCls + '__link" href="' + result.uri + '"><span class="' + $listBaseCls + '__link-title">'+ result.title + '</span></a></li>';
                }
                html + '</ul>';
                html += '</div>';
                
                marker.html = html;
            }
            else
            {
                marker.text = '';
             
                var result = marker.results[0];
                
                var html = '<div class="' + $popupBaseCls + '">';
                html += '<div class="' + $itemBaseCls + '">';
                
                html += '<div class="' + $itemBaseCls + '-content">';
                
                html += '<div class="' + $itemBaseCls + '-content-title"><a href="' + result.uri + '">' + result.title + '</a></div>';
                html += '<div class="' + $itemBaseCls + '-content-text">' + result.excerpt + '</div>';
                
                html += '</div>';
                
                if (result.imgSrc)
                {
                    html += '<div class="' + $itemBaseCls + '-img-wrap">';
                    html += '<img alt="" src="' + result.imgSrc + '"/>';
                    html += '</div>';
                }
                
                html += '</div>';
                html += '</div>';
                
                marker.html = html;
            }
        }
	},
	
	_showResultMap: function(searchMapId)
	{
		// Create map
		let $mapContainer = AmetysResultMap.$dialogEl.find(AmetysResultMap.SEARCH_MAP_SELECTOR);
        AmetysResultMap.map = L.map($mapContainer[0]);
        
		AmetysResultMap.$dialogEl.show();
		AmetysResultMap.$overlayEl.show();
				
        // Fit bounds
        if ( ! $j.isEmptyObject(AmetysResultMap.markers))
        {
            var latlngs = [];
            
            for (var i in AmetysResultMap.markers)
            {
                var $marker = AmetysResultMap.markers[i];
                var icon = new AmetysMarkers.Icon({text: $marker.text});
                
                var marker = L.marker([$marker.lat, $marker.lng], {icon: icon}).bindPopup($marker.html, {
                    maxWidth: 400
                });
                marker.addTo(AmetysResultMap.map);
                
                var latlng = L.latLng($marker.lat, $marker.lng);
                latlngs.push(latlng);
            }
            
            var latLngBounds = L.latLngBounds(latlngs);
            AmetysResultMap.map.fitBounds(latLngBounds).zoomOut(1, {animate:false});
        }
        else
        {
            AmetysResultMap.map.fitWorld();
        }
        
        // Add contribution
        L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
        }).addTo( AmetysResultMap.map);
						
        // Trap focus into modal
        AmetysFront.Accessibility.trapFocus(AmetysResultMap.$dialogEl.get(0), true);
        // Close modal when ESCAPE key is pressed
        AmetysResultMap.$dialogEl.on('keydown', AmetysResultMap._hideSearchMapOnEscape);
	},
	
	_hideSearchMapOnEscape: function(event)
	{
		if (event.key === "Escape") {
          AmetysResultMap._hideResultMap();
        }
	},
	
	_hideResultMap: function()
	{
		var $dialog = $j(this.SEARCH_MAP_DIALOG_SELECTOR);
		
		// Untrap focus
		AmetysFront.Accessibility.untrapFocus(AmetysResultMap.$dialogEl.get(0));
		
		AmetysResultMap.$dialogEl.hide();
		AmetysResultMap.$overlayEl.hide();
		
		if (AmetysResultMap.map)
        {
            AmetysResultMap.map.remove();
        }
		
		AmetysResultMap.$dialogEl.off('keydown', AmetysResultMap._hideSearchMapOnEscape);
		AmetysResultMap.$invokerEl.trigger('focus');
	}
}