<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="skin://services/common.xsl"/>    

    <xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:variable name="subtitle" select="ametys:serviceParameter('subtitle')/text()"/>
    <xsl:variable name="searchPageId" select="ametys:serviceParameter('search-page')/text()"/>
    <xsl:variable name="refTableId" select="ametys:serviceParameter('refTableId')/text()"/>
    <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    <xsl:variable name="iconFolderName" select="translate(substring-after($refTableId, 'odf-enumeration.'), $uppercase, $lowercase)"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="is-empty" select="count(items/item) = 0"/>    
    <xsl:variable name="common-service-css-class-name">service-odf-refitems second-nav</xsl:variable> 
    
    <xsl:template name="common-service-head-css">
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('zones/second-nav/second-nav.css')}" type="text/css" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/js/vendor/slick/slick.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/vendor/slick/slick.min.js')}" defer=""></script>
        <script type="text/javascript" src="{ametys:skinURL('zones/second-nav/second-nav.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>        
        </xsl:call-template>
    </xsl:template>   
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">  
        <xsl:if test="$subtitle != ''">
            <h2 class="service-subtitle">
                <xsl:call-template name="text.nl2br">
                    <xsl:with-param name="input"><xsl:value-of select="$subtitle"/></xsl:with-param>
                </xsl:call-template>
            </h2>
        </xsl:if>
        
        <ul class="second-nav-items">
            <xsl:apply-templates select="/items/item"/>
        </ul>
        
        <div class="second-nav-wrapper"></div>
    </xsl:template>  
    
    <!-- Item to exclude -->
    <xsl:template match="item[@code = 'HD']"/>
    
    <xsl:template match="item">
        <div class="second-nav-item">
            <xsl:choose>
                <xsl:when test="/items/search-form/criterion">
                    <form action="{resolver:resolve('page', $searchPageId)}" method="POST">
                        <input type="hidden" name="user.input.criterion.{/items/search-form/criterion}" value="{@id}"/>
                        <input type="hidden" name="submit-form" value="true" />
                        <a href="javascript:void(0)" onclick="$j(this).parent('form').submit()">
                            <xsl:apply-templates select="." mode="ref-item-icon"/>
                            <xsl:apply-templates select="." mode="ref-item-title"/>
                        </a>
                    </form>
                </xsl:when>
                <xsl:otherwise>
                    <a href="javascript:void(0)" onclick="$j(this).parent('form').submit()">
                        <xsl:apply-templates select="." mode="ref-item-icon"/>
                        <xsl:apply-templates select="." mode="ref-item-title"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="item" mode="ref-item-title">
        <span class="link"><xsl:value-of select="."/></span>
    </xsl:template>
    
    <xsl:template match="item" mode="ref-item-icon">
        <xsl:variable name="iconUrl" select="concat('templates/common/img/icon/', $iconFolderName, '/', @code, '.svg')"/>
        <img data-svg="true" src="{ametys:skinURL($iconUrl)}" alt=""/>
    </xsl:template>
    
</xsl:stylesheet>