<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="exslt">
    
    <xsl:import href="plugin:odf-web://pages/services/program-list/program-list_1.3.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/sitemap/sitemap.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/program-list/program-list.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('zones/sitemap/sitemap.js')}"/>
    </xsl:template>
    
    <xsl:template name="programs-list-one-level">
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <program-ref refid="{$refid}" />
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        
        <xsl:if test="$firstLevelItems[1]">
            <xsl:apply-templates select="$firstLevelItems" mode="one-level">
                <xsl:with-param name="program-refs" select="$program-refs"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="programs-list-two-levels">
        <!-- Program refs node set-->
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '' and metadata[@path = $secondLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <xsl:for-each select="../../metadata[@path = $secondLevel]/value">
                                <second value="{.}">
                                    <program-ref refid="{$refid}" />
                                </second>
                            </xsl:for-each>
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        <xsl:variable name="secondLevelItems" select="/xml/items[@metadataPath = $secondLevel]/item" />
    
        <xsl:if test="$firstLevelItems[1] and $secondLevelItems[1]">
            <xsl:apply-templates select="$firstLevelItems" mode="two-level">
                <xsl:with-param name="program-refs" select="$program-refs"/>
                <xsl:with-param name="secondLevelItems" select="$secondLevelItems"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="one-level">
        <xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        <xsl:variable name="refs" select="$first/program-ref" />
         
        <xsl:if test="$refs[1]">
            <details>
                <summary><xsl:value-of select="."/></summary>
                <div class="sitemap-nav">
                    <ul class="sitemap">
                        <xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" />
                    </ul>
                </div>
            </details>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="two-level">
        <xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        <xsl:param name="secondLevelItems" select="/.." /> <!-- default value is empty node set -->
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        
        <xsl:if test="$first/second/@value = $secondLevelItems/@id">
            <div class="ametys-faq">
            <details>
                <summary><xsl:value-of select="."/></summary>
                
                <xsl:for-each select="$secondLevelItems">
                    <xsl:variable name="refs" select="$first/second[@value = current()/@id]/program-ref" />
                    
                    <xsl:if test="$refs[1]">
                        <details>
                            <summary><xsl:value-of select="."/></summary>
                            <div class="sitemap-nav">
                                <ul class="sitemap">
                                    <xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" />
                                </ul>
                            </div>
                        </details>
                    </xsl:if>
                </xsl:for-each>
            </details>
            </div>
        </xsl:if>
    </xsl:template>
        
    <xsl:template match="program">
        <xsl:choose>
            <xsl:when test="$displaySubProgram = 'true' and subprogram">
                <li class="sitemap__item sitemap__item--has-children">
                    <div class="sitemap__item-content">
                        <button class="sitemap__toggle"
                                aria-expanded="false"
                                aria-label="{@title}"
                                aria-controls="subpages-{generate-id()}">
                        </button>
                        <a class="sitemap__link" href="{resolver:resolve('odf', @id)}"><xsl:value-of select="@title"/></a>
                    </div>
                    <ul id="subpages-{generate-id()}" hidden="true">
                        <xsl:apply-templates select="subprogram"/>
                    </ul>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li class="sitemap__item">
                  <a class="sitemap__link" href="{resolver:resolve('odf', @id)}"><xsl:value-of select="@title"/></a>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="subprogram">
        <li class="sitemap__item">
          <a class="sitemap__link" href="{resolver:resolve('odf', @id)}"><xsl:value-of select="@title"/></a>
        </li>
    </xsl:template>

</xsl:stylesheet>
