<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="service:odf-web://pages/services/schema/schema_1.3.xsl"/>
    
    <xsl:variable name="but" select="odf:getEntryId('odf-enumeration.Degree', 'BUT')"/><!-- BUT -->
    
    <!-- Note : 3 general studies formats : general-studies, general-studies-mobile and general-studies displayed with health studies -->
    
    <xsl:template name="canvas">
        <svg class="svg-desktop" width="1135px" height="432px" viewBox="0 0 1135 432" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <xsl:call-template name="background-with-but"/>
            <xsl:call-template name="general-studies-with-but"/>
            <xsl:call-template name="texts-with-but"/>
        </svg>
    
        <svg class="svg-mobile" width="379px" height="419px" viewBox="0 0 379 419" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <xsl:call-template name="background-mobile-with-but"/>
            <xsl:call-template name="general-studies-mobile-with-but"/>
            <xsl:call-template name="texts-mobile-with-but"/>
        </svg>
        
        <xsl:call-template name="search-forms" />
        
        <!-- Search form for BUT -->
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">but</xsl:with-param>
            <xsl:with-param name="domainId" select="$but"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="background-with-but">
        <g id="lignes" transform="translate(37.000000, 0.000000)" class="st3">
            <line x1="0" y1="328.5" x2="1096" y2="328.5" id="Line-7-Copy"></line>
            <line x1="0" y1="287.5" x2="1096" y2="287.5" id="Line-7-Copy-2"></line>
            <line x1="0" y1="246.5" x2="1096" y2="246.5" id="Line-7-Copy-3"></line>
            <line x1="0" y1="205.5" x2="1096" y2="205.5" id="Line-7-Copy-4"></line>
            <line x1="0" y1="164.5" x2="1096" y2="164.5" id="Line-7-Copy-5"></line>
            <line x1="0" y1="123.5" x2="1096" y2="123.5" id="Line-7-Copy-6"></line>
            <line x1="0" y1="82.5" x2="1096" y2="82.5" id="Line-7-Copy-7"></line>
            <line x1="0" y1="41.5" x2="1096" y2="41.5" id="Line-7-Copy-8"></line>
            <line x1="0" y1="0.5" x2="1096" y2="0.5" id="Line-7-Copy-9"></line>
        </g>
        <g id="lignes-pleines" class="st4">
            <line x1="0" y1="278.5" x2="22" y2="278.5" id="Line-7-Copy-22"></line>
            <line x1="0" y1="199.5" x2="22" y2="199.5" id="Line-7-Copy-20"></line>
            <line x1="0" y1="118.5" x2="22" y2="118.5" id="Line-7-Copy-18"></line>
            <line x1="0" y1="37.5" x2="22" y2="37.5" id="Line-7-Copy-16"></line>
        </g>
    </xsl:template>
    
    <xsl:template name="background-mobile-with-but">
        <g id="lignes" transform="translate(37.000000, 62.000000)" class="st3">
            <line x1="0" y1="248.5" x2="340" y2="248.5" id="Line-7-Copy"></line>
            <line x1="0" y1="217.5" x2="340" y2="217.5" id="Line-7-Copy-2"></line>
            <line x1="0" y1="186.5" x2="340" y2="186.5" id="Line-7-Copy-3"></line>
            <line x1="0" y1="155.5" x2="340" y2="155.5" id="Line-7-Copy-4"></line>
            <line x1="0" y1="124.5" x2="340" y2="124.5" id="Line-7-Copy-5"></line>
            <line x1="0" y1="93.5" x2="340" y2="93.5" id="Line-7-Copy-6"></line>
            <line x1="0" y1="62.5" x2="340" y2="62.5" id="Line-7-Copy-7"></line>
            <line x1="0" y1="31.5" x2="340" y2="31.5" id="Line-7-Copy-8"></line>
            <line x1="0" y1="0.5" x2="340" y2="0.5" id="Line-7-Copy-9"></line>
        </g>
        <g id="lignes-pleines" class="st4">
            <line x1="0" y1="278.5" x2="22" y2="278.5" id="Line-7-Copy-22"></line>
            <line x1="0" y1="217.5" x2="22" y2="217.5" id="Line-7-Copy-20"></line>
            <line x1="0" y1="155.5" x2="22" y2="155.5" id="Line-7-Copy-18"></line>
            <line x1="0" y1="93.5" x2="22" y2="93.5" id="Line-7-Copy-16"></line>
        </g>
    </xsl:template>
    
    <xsl:template name="general-studies-with-but">
        <g>
            <!-- Licence -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licence').submit(); return false;">
                <path d="M150,246 L585,246 C593.284271,246 600,252.715729 600,261 L600,369 L600,369 L150,369 L150,246 Z" id="260px" class="st6"></path>
            </a>
            <!-- BUT -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_BUT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-but').submit(); return false;">
                <g id="80px" transform="translate(799.000000, 246.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="193" height="123"></rect>
                    <path d="M0,0 L178,0 C186.284271,2.54560899e-16 193,6.71572875 193,15 L193,123 L193,123 L0,123 L0,0 Z" id="Rectangle-Copy-6" class="st9"></path>
                </g>
            </a>
            <!-- DEUST -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_NA" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-na').submit(); return false;">
                <g id="80px" transform="translate(600.000000, 287.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="199" height="82"></rect>
                    <rect id="Rectangle-Copy-6" class="st13" x="0" y="0" width="199" height="82"></rect>
                </g>
            </a>
            <!-- Master -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-master').submit(); return false;">
                <g id="110px" transform="translate(343.000000, 162.000000)">
                    <rect id="Rectangle-Copy" class="st5" x="0" y="0" width="193" height="84"></rect>
                    <rect id="Rectangle-Copy-3" class="st15" x="0" y="0" width="193" height="84"></rect>
                </g>
            </a>
            <!-- Ecole d'ingenieur -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-di').submit(); return false;">
                <g id="110px" transform="translate(150.000000, 162.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="193" height="126"></rect>
                    <path d="M0,0 L178,0 C186.284271,-1.52179594e-15 193,6.71572875 193,15 L193,126 L193,126 L0,126 L0,0 Z" id="Rectangle-Copy-6" class="st16"></path>
                </g>
            </a>
            <!-- Doctorat -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-doctorat').submit(); return false;">
                <g id="110px" transform="translate(343.000000, 40.000000)">
                    <rect id="Rectangle-Copy-2" class="st5" x="0" y="0" width="193" height="122"></rect>
                    <path d="M0,0 L178,0 C186.284271,-1.52179594e-15 193,6.71572875 193,15 L193,122 L193,122 L0,122 L0,0 Z" id="Rectangle-Copy-4" class="st17"></path>
                </g>
            </a>
            <!-- Licence pro -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licencepro').submit(); return false;">
                <g id="200px" transform="translate(536.000000, 246.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="263" height="41"></rect>
                    <rect id="Rectangle-Copy-6" class="st18" x="0" y="0" width="263" height="41"></rect>
                </g>
            </a>
            <!-- Baccalauréat, DAEU, ... -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-cm').submit(); return false;">
                <g id="700px" transform="translate(34.000000, 370.000000)">
                    <rect id="Rectangle-Copy-6" x="0" y="0" width="1100" height="61" class="st24"></rect>
                </g>
            </a>
        </g>
    </xsl:template>
    
    <xsl:template name="general-studies-mobile-with-but">
        <g>
             <!-- Licence -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licence').submit(); return false;">
                <path d="M35,248 L219,248 C227.284271,248 234,254.715729 234,263 L234,341 L234,341 L35,341 L35,248 Z" id="260px" class="st6"></path>
            </a>
            <!-- BUT -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_BUT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-but').submit(); return false;">
                <g id="60px" transform="translate(294.000000, 248.000000)">
                    <rect id="Rectangle-Copy-5" fill="#FFFFFF" x="0" y="0" width="60" height="93"></rect>
                    <path d="M0,0 L45,0 C53.2842712,-1.52179594e-15 60,6.71572875 60,15 L60,93 L60,93 L0,93 L0,0 Z" id="Rectangle-Copy-6" class="st9"></path>
                </g>
            </a>
            <!-- DEUST -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_NA" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-na').submit(); return false;">
                <g id="60px" transform="translate(234.000000, 278.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="60" height="63"></rect>
                    <rect id="Rectangle-Copy-6" class="st13" x="0" y="0" width="60" height="63"></rect>
                </g>
            </a>
            <!-- Master -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-master').submit(); return false;">
                <g id="95px" transform="translate(115.000000, 185.000000)">
                    <rect id="Rectangle-Copy" class="st5" x="0" y="0" width="80" height="63"></rect>
                    <rect id="Rectangle-Copy-3" class="st15" x="0" y="0" width="80" height="63"></rect>
                </g>
             </a>
             <!-- Ecole d'ingenieur -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-di').submit(); return false;">
                <g id="90px" transform="translate(33.000000, 184.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="2" y="0" width="80" height="94"></rect>
                    <path d="M2,0 L67,0 C75.2842712,-1.52179594e-15 82,6.71572875 82,15 L82,94 L82,94 L2,94 L2,0 Z" id="Rectangle-Copy-6"  class="st16"></path>
                </g>
            </a>
            <!-- Doctorat -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-doctorat').submit(); return false;">
                <g id="95px" transform="translate(115.000000, 93.000000)">
                    <rect id="Rectangle-Copy-2" class="st5" x="0" y="0" width="80" height="92"></rect>
                    <path d="M0,0 L65,0 C73.2842712,-1.52179594e-15 80,6.71572875 80,15 L80,92 L80,92 L0,92 L0,0 Z" id="Rectangle-Copy-4" class="st17"></path>
                </g>
            </a>
            <!-- Licence pro -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licencepro').submit(); return false;">
                <g id="195px" transform="translate(195.000000, 248.000000)">
                    <rect id="Rectangle-Copy-5" class="st5"  x="0" y="0" width="99" height="30"></rect>
                    <rect id="Rectangle-Copy-6" class="st18"  x="0" y="0" width="99" height="30"></rect>
                </g>
            </a>
            <!-- Baccalauréat, DAEU, ... -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-cm').submit(); return false;">
                <g id="700px" transform="translate(34.000000, 342.000000)">
                    <rect id="Rectangle-Copy-6" x="0" y="0" width="320" height="77" class="st24"></rect>
                </g>
            </a>
        </g>
    </xsl:template>
    
    <xsl:template name="texts-with-but">
        <g id="textes" transform="translate(0.000000, 44.000000)">
            <text id="Licence">
                <tspan x="347.285156" y="289" class="st7 st1 st8">Licence</tspan>
            </text>
            <text id="DEUST-Diplôme-d’étud">
                <tspan x="678.65332" y="264" class="st7 st1 st8">DEUST</tspan>
                <tspan x="726.286133" y="264.96875" font-size="14"></tspan>
                <tspan x="659.80127" y="283.96875" class="st7 st11 st12">Diplôme d’études </tspan>
                <tspan x="630" y="298.96875" class="st7 st11 st12">universitaires scientifiques </tspan>
                <tspan x="672.153809" y="313.96875" class="st7 st11 st12">et techniques  </tspan>
            </text>
            <text id="BUT-Bachelor-univers">
                <tspan x="882.730469" y="250.03125" class="st7 st1 st8">BUT</tspan>
                <tspan x="921.183594" y="252" font-size="14"></tspan>
                <tspan x="837.476562" y="271" class="st7 st11 st12">Bachelor universitaire </tspan>
                <tspan x="859.80957" y="288" class="st7 st11 st12">de technologie</tspan>
            </text>
            <text id="Master">
                <tspan x="414.832031" y="165" class="st7 st1 st8">Master</tspan>
            </text>
            <text id="Ecole-d’ingénieur">
                <tspan x="227.589844" y="177" class="st7 st1 st8">Ecole </tspan>
                <tspan x="206.789062" y="196" class="st7 st1 st8">d’ingénieur</tspan>
            </text>
            <text id="Doctorat">
                <tspan x="408.867188" y="62" class="st7 st1 st8">Doctorat</tspan>
            </text>
            <text id="Licence-professionne">
                <tspan x="582.398438" y="227" class="st7 st1 st8">Licence professionnelle</tspan>
            </text>
            <text id="Baccalauréat---Capac">
                <tspan x="260.082031" y="356" class="st7 st1 st8">Baccalauréat  -  Capacité en médecine   -  Capacité en droit  -  DAEU  -  Diplôme équivalent</tspan>
            </text>
            <text id="Bac">
                <tspan x="0" y="355" class="st0 st1 st2">Bac</tspan>
            </text>
            <text id="+2">
                <tspan x="0" y="258" class="st0 st1 st2">+2</tspan>
            </text>
            <text id="+4">
                <tspan x="0" y="175" class="st0 st1 st2">+4</tspan>
            </text>
            <text id="+6">
                <tspan x="0" y="94" class="st0 st1 st2">+6</tspan>
            </text>
            <text id="+8">
                <tspan x="0" y="13" class="st0 st1 st2">+8</tspan>
            </text>
        </g>
    </xsl:template>
    
    <xsl:template name="texts-mobile-with-but">
        <g id="textes" transform="translate(0.000000, 94.000000)">
            <text id="Licence">
                <tspan x="110.749512" y="216" class="st7 st1 st25">Licence</tspan>
            </text>
            <text id="BUT">
                <tspan x="310.714355" y="203" class="st7 st1 st25">BUT</tspan>
            </text>
            <text id="DEUST">
                <tspan x="242.323242" y="218" class="st7 st1 st25">DEUST</tspan>
            </text>
            <text id="Master">
                <tspan x="132.978027" y="125" class="st7 st1 st25">Master</tspan>
            </text>
            <text id="Ecole-d’ingénieur">
                <tspan x="60.940918" y="132.152344" class="st7 st1 st25">Ecole </tspan>
                <tspan x="42.7402344" y="146.152344" class="st7 st1 st25">d’ingénieur</tspan>
            </text>
            <text id="Doctorat">
                <tspan x="127.758789" y="48"  class="st7 st1 st25">Doctorat</tspan>
            </text>
            <text id="Licence-pro">
                <tspan x="208.639648" y="172" class="st7 st1 st25">Licence pro</tspan>
            </text>
            <text id="Baccalauréat---Capac" class="st7 st1 st25">
                <tspan x="86.0800781" y="268">Baccalauréat  -  Capacité en médecine   -  </tspan>
                <tspan x="97.4072266" y="289">Capacité en droit  -  DAEU  -  Diplôme </tspan>
                <tspan x="181.813965" y="310">équivalent</tspan>
            </text>
            <text id="Bac">
                <tspan x="0" y="267" class="st0 st1 st26">Bac</tspan>
            </text>
            <text id="+2">
                <tspan x="0" y="199" class="st0 st1 st26">+2</tspan>
            </text>
            <text id="+4">
                <tspan x="0" y="137" class="st0 st1 st26">+4</tspan>
            </text>
            <text id="+6">
                <tspan x="0" y="75" class="st0 st1 st26">+6</tspan>
            </text>
            <text id="+8">
                <tspan x="0" y="13" class="st0 st1 st26">+8</tspan>
            </text>
        </g>
    </xsl:template>
    
</xsl:stylesheet>