<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <!-- The placeholder for fulltext search field -->
    <xsl:variable name="searchInputPlaceholder" select="ametys:serviceViewParameter('searchInputPlaceholder')"/>

    <!-- Prefix for "Full text" criteria -->
    <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
    <!-- Prefix for  "Title or full text" criteria -->
    <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form role="search" method="post" class="form search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
            <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:if test="$result-display-type = 'ON_PAGE'">
                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
            </xsl:if>
            
            <xsl:call-template name="form-search"/>
        </form> 
    </xsl:template>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div class="field">
            <xsl:apply-templates select="." mode="field-label"/>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="labelFor"><xsl:value-of select="$id"/><xsl:if test="type = 'date' or type = 'datetime'">-clone</xsl:if></xsl:variable>
        <label for="{$labelFor}">
        	<xsl:apply-templates select="." mode="field-label-text"/>
        </label>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="search" name="{@name}" value="{$value}">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:choose>
            <xsl:when test="$searchInputPlaceholder != ''">
                <xsl:attribute name="placeholder"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_TEXTFIELD_DEFAULT_PLACEHOLDER</xsl:attribute>
                <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_TEXTFIELD_DEFAULT_PLACEHOLDER</xsl:attribute>
                <xsl:attribute name="i18n:attr">placeholder title</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
        <xsl:attribute name="title"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">    
        <xsl:param name="value"/>
    
        <xsl:variable name="dropdownSort" select="ametys:serviceViewParameter('dropdownSort')"/> 
        
        <xsl:variable name="options">
            <items>
                <xsl:choose>
                    <xsl:when test="$dropdownSort = 'order'">
                        <!-- Sort items by order, then alpha -->
                        <xsl:for-each select="enumeration/item">
                            <xsl:sort select="not(@order)" data-type="number"/><!-- items with no order at the end -->
                            <xsl:sort select="@order" data-type="number"/>
                            <xsl:sort select="label" />
                            
                            <xsl:variable name="itemValue" select="@value" />
                            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', ../../@definition)"></xsl:value-of></xsl:variable>
                            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                            <xsl:if test="$compute-counts = 'false' or $count > 0">
                                <item value="{@value}" count="{$count}">
                                    <xsl:if test="@value = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
                                    <xsl:copy-of select="label" />
                                </item>
                            </xsl:if>
                         </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Alpha sort -->
                        <xsl:for-each select="enumeration/item">
                            <xsl:sort select="label" />
                            
                            <xsl:variable name="itemValue" select="@value" />
                            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', ../../@definition)"></xsl:value-of></xsl:variable>
                            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                            <xsl:if test="$compute-counts = 'false' or $count > 0">
                                <item value="{@value}" count="{$count}">
                                    <xsl:if test="@value = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
                                    <xsl:copy-of select="label" />
                                </item>
                            </xsl:if>
                         </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </items>
        </xsl:variable>
        
        <div class="a11y-select" data-placeholder="{label}" data-multiple="true">
          <xsl:if test="count(exsl:node-set($options)/items/item) > 10">
            <xsl:attribute name="data-searchable">true</xsl:attribute>
          </xsl:if>
          <button type="button" class="a11y-select__button" id="a11y-sel-btn-{generate-id()}" aria-haspopup="listbox" aria-expanded="false" aria-controls="a11y-sel-list-{generate-id()}">
              <xsl:value-of select="label"></xsl:value-of>
          </button>

          <xsl:variable name="inputName" select="@name"/>
          <ul class="a11y-select__list" id="a11y-sel-list-{generate-id()}" role="listbox" aria-multiselectable="true" tabindex="-1">
            <xsl:for-each select="exsl:node-set($options)/items/item">
                <li class="a11y-select__option" role="option" aria-selected="{@selected}" data-value="">
                    <label class="a11y-select__check">
                        <input type="checkbox" tabindex="-1" name="{$inputName}" value="{@value}">
                            <xsl:if test="@selected = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                        </input>
                        <span><xsl:value-of select="label" /></span>
                    </label>
                </li>
            </xsl:for-each>
          </ul>

          <!-- La valeur sérialisée pour les formulaires (CSV) -->
          <input class="a11y-select__input" type="hidden" name="" value=""/>
        </div>
    </xsl:template>
    
    <xsl:template name="submit-inputs-button">
        <button type="submit" class="btn btn-primary">
            <xsl:attribute name="onclick" ><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
            <i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
</xsl:stylesheet>