<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:import href="skin://services/web/pages/services/search/common/criteria.xsl"/>
    
    <!-- Criteria in grid -->
    <xsl:template name="form-search">
        <div class="grid-form">
            <xsl:for-each select="/search/form/fields/criterion">
                <xsl:apply-templates select="." mode="field">
                    <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </div>
        
        <xsl:call-template name="submit-inputs"/>
    </xsl:template>
    
</xsl:stylesheet>