<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:variable name="maxVisibleFacetItems">5</xsl:variable>
    
    <xsl:template name="facet-filter">
        <xsl:if test="/search/form/facets/facet[@total > 0]">
            <xsl:variable name="unique" select="concat('search-facet-', substring-after(math:random(), '.'))"/>
            <div id="{$unique}" class="facets" data-ametys-search-role="facet-filters" role="group" aria-label="plugin.web:PLUGINS_WEB_SERVICE_SEARCH_FILTERS_GROUP_ARIA_LABEL" i18n:attr="aria-label">
                
                <xsl:call-template name="facet-filter-title"/>
                
                <xsl:call-template name="facet-selected-facets"/>
                
                <xsl:for-each select="/search/form/facets/facet[@total > 0]">
                    <details class="sidebar-details">
                        <xsl:if test="item[@selected = 'true']">
                            <xsl:attribute name="open">open</xsl:attribute>
                        </xsl:if>
                        <xsl:call-template name="facet-filter-name"/>
                        <div class="checkbox-list" data-ametys-search-role="facet-filter" data-ametys-search-facet-name="{current()/@name}">
                            <xsl:call-template name="facet-filter-list"/>
                        </div>
                        <xsl:call-template name="facet-filter-show-more"/>
                    </details>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="facet-filter-mobile-btn">
        <button class="btn btn-primary btn-mobile-filters">
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_FILTER" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="facet-filter-title">
        <h2 class="sidebar-title"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_FACETS_TITLE" i18n:catalogue="skin.{$skin}"/></h2>
    </xsl:template>
    
    <xsl:template name="facet-selected-facets">
        <xsl:if test="/search/form/facets/facet/item[@selected = 'true']">
            <div class="sidebar-active-selection">
                <xsl:for-each select="/search/form/facets/facet[item/@selected = 'true']">
                    <xsl:variable name="facetName" select="@name"/>
                    <xsl:for-each select="item[@selected = 'true']">
                        <div class="tag-active">
                            <span><xsl:value-of select="."/></span>
                            <button data-value="{@value}" data-facet="{$facetName}" onclick="removeFilter(this)">
                                <xsl:variable name="i18nparams"><page><xsl:value-of select="."/></page></xsl:variable> 
                                <xsl:attribute name="aria-label">
                                    <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_REMOVE_FILTER'), $lang, $i18nparams)"/>
                                </xsl:attribute>
                                <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                                    <path d="M5 4.09091L9.09091 0L10 0.909091L5.90909 5L10 9.09091L9.09091 10L5 5.90909L0.909091 10L0 9.09091L4.09091 5L0 0.909091L0.909091 0L5 4.09091Z" fill="#2E1E3D"></path>
                                </svg>
                            </button>
                        </div>
                    </xsl:for-each>
                </xsl:for-each>
            </div>
            <script>
                function removeFilter(btn)
                {
                    let facetName = $j(btn).attr('data-facet');
                    let facetValue = $j(btn).attr('data-value');
                    let $facet = $j(`.sidebar-details .checkbox-item input[name='${facetName}'][value='${facetValue}']`);
                    if ($facet.length)
                    {
                        // Trigger click event directly on DOM, as inline since jquery 3.4.1 onclick on a checkbox input is executed 3 times when called via $(...).trigger('click')
                        // https://github.com/jquery/jquery/issues/4493
                        // https://github.com/jquery/jquery/wiki/Won't-Fix#inline-event-handlers
                        $facet[0].click();
                    }
                }
            </script>
        </xsl:if>
    </xsl:template>
    
    <!-- Override to sort by count -->
    <xsl:template name="facet-filter-elements">
        <xsl:for-each select="item[@count > 0]">
            <xsl:sort select="@count" order="descending"/>
            
            <xsl:call-template name="facet-filter-element"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="facet-filter-name">
        <summary>
            <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                <path d="M11.6873 3.68744C11.6873 1.92704 10.2602 0.5 8.49983 0.5C6.73944 0.5 5.3124 1.92704 5.3124 3.68744C5.3124 5.44783 6.73944 6.87488 8.49983 6.87488C10.2602 6.87488 11.6873 5.44783 11.6873 3.68744ZM7.75577 8.50512C5.78586 7.2992 2.59511 6.96784 0.989434 6.87654C0.449894 6.84599 0 7.25704 0 7.77599V15.1735C0 15.6493 0.384817 16.0461 0.879534 16.0716C2.32915 16.1477 5.26193 16.4262 7.28894 17.4472C7.60005 17.6039 7.96893 17.3904 7.96893 17.0531V8.88562C7.96859 8.73056 7.8919 8.58846 7.75577 8.50512ZM16.0102 6.87654C14.4049 6.96751 11.2138 7.2992 9.24423 8.50512C9.1081 8.58846 9.03141 8.73621 9.03141 8.89126V17.0521C9.03141 17.3904 9.40128 17.6043 9.71338 17.4472C11.7401 16.4272 14.6712 16.1487 16.1205 16.0726C16.6152 16.0467 17 15.65 17 15.1742V7.77599C16.9997 7.25704 16.5498 6.84599 16.0102 6.87654Z" fill="#521C7E"></path>
            </svg>
            <xsl:value-of select="label"/>
        </summary>
    </xsl:template>
    
    <xsl:template name="facet-filter-element">
        <xsl:variable name="id" select="concat(../@name, '-', substring-after(math:random(), '.'))"/>
        <div class="checkbox-item">
            <xsl:call-template name="facet-filter-element-checkbox">
               <xsl:with-param name="selected" select="@selected"/>
               <xsl:with-param name="id" select="$id"/>
           </xsl:call-template>
           <label for="{$id}"><xsl:value-of select="text()"/> (<xsl:value-of select="@count"/>)</label>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter-show-more">
        <button type="button" class="btn btn-showmore"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_FACETS_SHOW_MORE" i18n:catalogue="skin.{$skin}"/></button>
    </xsl:template>
    
</xsl:stylesheet>