<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
    
    <xsl:template name="pagination">
        <form id="reload">
            <nav class="pagination" role="navigation" aria-label="skin.{$skin}:SKIN_SEARCH_NAV_PAGINATION_LABEL" i18n:attr="aria-label">
                <ul>
                    <xsl:apply-templates select="ametys:pagination(/search/pagination/@total + 0, /search/pagination/@current + 0, 0, 10, 0)" mode="search-pagination">
                        <xsl:with-param name="original-context-node" select="/"/>
                    </xsl:apply-templates>
                </ul>
            </nav>
        </form>
    </xsl:template>
    
    <xsl:template match="gotofirstpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="page prec">
                <button aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST_TITLE" i18n:attr="aria-label">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
                            <xsl:with-param name="page" select="."/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                        <path d="M10.5 1.57715L6.40909 6.48624L10.5 11.3953" stroke="#2E1E3D" stroke-width="2"></path>
                        <path d="M5.58984 1.57715L1.49894 6.48624L5.58984 11.3953" stroke="#2E1E3D" stroke-width="2"></path>
                    </svg>
                </button>
            </li>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template match="gotopreviouspage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li>
                <button aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE_TITLE" i18n:attr="aria-label">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
                            <xsl:with-param name="page" select="."/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <svg width="8" height="15" viewBox="0 0 8 15" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                        <path d="M6.5 1.48633L1.5 7.48633L6.5 13.4863" stroke="#2E1E3D" stroke-width="2"></path>
                    </svg>            
                </button>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <li class="page">
            <button>
                <xsl:variable name="i18nparams"><page><xsl:value-of select="."/></page></xsl:variable> 
                <xsl:attribute name="aria-label">
                    <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_SEARCH_NAV_GO_TO_PAGE_LABEl'), $lang, $i18nparams)"/>
                </xsl:attribute>
                <xsl:attribute name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:value-of select="."/>
            </button>
        </li>
    </xsl:template>
    
    <xsl:template match="current" mode="search-pagination">
        <li class="page active" aria-current="true"><xsl:value-of select="."/></li>
    </xsl:template>
    
    <xsl:template match="gotonextpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="page suiv">
                <button aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT_TITLE" i18n:attr="aria-label">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
                            <xsl:with-param name="page" select="."/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <svg width="8" height="15" viewBox="0 0 8 15" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                        <path d="M1.5 13.4863L6.5 7.48633L1.5 1.48633" stroke="#2E1E3D" stroke-width="2"></path>
                    </svg>
                </button>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="gotolastpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="page suiv">
                <button aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_LAST_TITLE" i18n:attr="aria-label">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
                            <xsl:with-param name="page" select="."/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                        <path d="M1.5 11.3955L5.59091 6.48642L1.5 1.57733" stroke="#2E1E3D" stroke-width="2"></path>
                        <path d="M6.41016 11.3955L10.5011 6.48642L6.41016 1.57733" stroke="#2E1E3D" stroke-width="2"></path>
                    </svg>
                </button>
            </li>
        </xsl:if>    
    </xsl:template>
</xsl:stylesheet>