<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:exslt="http://exslt.org/common"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        exclude-result-prefixes="ametys resolver escaper"> 
        
    <xsl:import href="skin://stylesheets/content/utils.xsl"/>
     
    <xsl:template name="search-map">
        <xsl:if test="/search/hits/hit">
            <div class="show-on-map">
                <button class="btn btn-primary" data-search-map-dialog-invoker="">
                    <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SEE_ON_MAP" i18n:catalogue="skin.{$skin}"/>    
                </button>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="search-map-mobile-btn">
        <button class="btn-secondary btn-secondary-show-on-map" data-search-map-dialog-invoker="">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                <path d="M12.2 6C9.878 6 8 7.878 8 10.2C8 13.35 12.2 18 12.2 18C12.2 18 16.4 13.35 16.4 10.2C16.4 7.878 14.522 6 12.2 6ZM12.2 11.7C11.372 11.7 10.7 11.028 10.7 10.2C10.7 9.372 11.372 8.7 12.2 8.7C13.028 8.7 13.7 9.372 13.7 10.2C13.7 11.028 13.028 11.7 12.2 11.7Z" fill="#521C7E"></path>
            </svg>
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SEE_ON_MAP" i18n:catalogue="skin.{$skin}"/>   
        </button>
    </xsl:template>            
    
    <xsl:template name="search-map-js">
        <script type="text/javascript">
            var searchMapResults = [];
            
            <xsl:for-each select="/search/hits/hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']">
            
                <xsl:variable name="imgSrc">
                    <xsl:call-template name="program-image-url">
                        <xsl:with-param name="contentId" select="id"/>
                        <xsl:with-param name="maxWidth" select="'130'"/>
                        <xsl:with-param name="maxHeight" select="'90'"/>
                    </xsl:call-template>
                </xsl:variable>
            
                searchMapResults.push({
                    id: '<xsl:value-of select="id"/>',
                    title: "<xsl:value-of select="ametys:escapeJS(title)"/>",
                    excerpt: "<xsl:value-of select="ametys:escapeJS(excerpt[1])"/>",
                    imgSrc: "<xsl:value-of select="$imgSrc"/>",
                    uri: "<xsl:value-of select="concat($site-uri-prefix, '/', uri, '.html')"/>",
                    markers: <xsl:call-template name="get-js-markers"/>
                });
            </xsl:for-each>     
            
            var hasMarkers = false;
            for (let i = 0; i &lt; searchMapResults.length; i++) {
                if(searchMapResults[i].markers.length &gt; 0)
                {
                    hasMarkers = true;
                    break;
                }
            }
            
            if (hasMarkers)
            {
	            AmetysResultMap.initialize(searchMapResults);
            }
            else
            {
                $j('[data-search-map-dialog-invoker]').parent.hide();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="search-map-dialog">
        <div style="display: none;" data-search-map-dialog="" class="ametys-search-map-dialog" role="dialog" aria-modal="true" aria-label="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_MAP_DIALOG" i18n:attr="aria-label">
            <button type="button" class="close" aria-label="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_MAP_DIALOG_CLOSE" i18n:attr="aria-label"></button>
            <div data-search-map="" style="height:100%"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="get-js-markers">
         <xsl:variable name="rawMarkers">
            <xsl:call-template name="content-geocode-marker">
                <xsl:with-param name="data" select="content"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="markers" select="exslt:node-set($rawMarkers)"/>
        
        <xsl:text>[</xsl:text>        
        <xsl:if test="$markers/markers/marker">
            <xsl:choose>
               <xsl:when test="$markers/markers/marker[@holder = 'geoCode']">
                    {lat: <xsl:value-of select="$markers/markers/marker[@holder = 'geoCode']/@lat"/>, lng: <xsl:value-of select="$markers/markers/marker[@holder = 'geoCode']/@lng"/>}
               </xsl:when>
               <xsl:when test="$markers/markers/marker[@holder = 'campus']">
                    <xsl:for-each select="$markers/markers/marker[@holder = 'campus']">
		                {lat: <xsl:value-of select="@lat"/>, lng: <xsl:value-of select="@lng"/>}
		                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
		            </xsl:for-each>
               </xsl:when>
               <xsl:when test="$markers/markers/marker[@holder = 'place']">
                    <xsl:for-each select="$markers/markers/marker[@holder = 'place']">
                        {lat: <xsl:value-of select="@lat"/>, lng: <xsl:value-of select="@lng"/>}
                        <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                    </xsl:for-each>
               </xsl:when>
            </xsl:choose>     
        </xsl:if>
        <xsl:text>]</xsl:text>       
    </xsl:template>
       
</xsl:stylesheet>