<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
    
    <xsl:import href="plugin:web://pages/services/search/search-default/results/search-results.xsl"/>
    
    <xsl:template name="search-results">
    	<div class="search-page-contents">
        	<xsl:call-template name="form-criteria-hidden"/>
        
	        <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
	            <xsl:call-template name="back-button"/>
	        </xsl:if>
	        
	        <xsl:if test="$result-display-type = 'ABOVE_CRITERIA' or $result-display-type = 'IN_PLACE_OF_CRITERIA'" >
	            <xsl:call-template name="form-result"/>
	            <xsl:call-template name="form-result-js"/>
	        </xsl:if>
	        
	        <xsl:choose>
	            <xsl:when test="/search/hits/hit">
		            <xsl:call-template name="hits"/>
	                <xsl:call-template name="pagination"/>
	            </xsl:when>
	            <xsl:otherwise>
	                <xsl:if test="/search/hits">
	                    <!-- hits is present but no single hit => there is no result -->
		                <xsl:call-template name="no-result"/>
	                </xsl:if>
	            </xsl:otherwise>
	        </xsl:choose>
	    </div>
    </xsl:template>
    
    <xsl:template name="form-result">
         <xsl:call-template name="anchor" />
         
         <xsl:if test="/search/hits/hit">
			<div class="search-page-contents-top">
                <xsl:call-template name="results-count"/>
	           	<xsl:call-template name="results-sort"/>
	        </div>
            
            <xsl:call-template name="form-result-mobile"/>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="results-count">
        <div class="nb-results">
            <xsl:choose>
                <xsl:when test="not(hits) or hits/@total = '0'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAMS_NO_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:when test="hits/@total = '1'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAMS_ONE_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:otherwise>
                    <i18n:translate>
                        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAMS_RESULTS" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param><xsl:value-of select="hits/@total"/></i18n:param>
                    </i18n:translate>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="results-sort">
        <xsl:if test="count(/search/form/sorts/sort) > 0">      
            <div class="filter-by">
                <span><i18n:text i18n:key="PLUGINS_WEB_SERVICE_SEARCH_VIEW_SORT_BY" i18n:catalogue="plugin.web"/></span>
                <select>
                    <xsl:attribute name="onchange">eval("function a(){" + this.options[this.selectedIndex].getAttribute('onselect') + "}"); try { a.call(this); } catch(e) { }; return true;</xsl:attribute>
                    
                    <xsl:call-template name="results-sort-opts"/>
                </select>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="results-sort-opts">
        <xsl:for-each select="/search/form/sorts/sort">
            <option value="{@name}">
                <xsl:attribute name="onselect"><xsl:call-template name="search-js-sort"/></xsl:attribute>
                <xsl:if test="@selected"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                
                <xsl:value-of select="label"/>
            </option>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="form-result-mobile">
        <div class="search-page__mobile-filters">
            <xsl:call-template name="facet-filter-mobile-btn"/>
            <xsl:call-template name="search-map-mobile-btn"/>                
        </div>
    </xsl:template>
    
    <xsl:template name="hits">
    	<ul data-ametys-search-role="hits" class="list-results">
    		<xsl:for-each select="/search/hits/hit">
    			<xsl:apply-templates select="."/>
    		</xsl:for-each>
		</ul>
    </xsl:template>
    
    <!-- Programs -->
	<xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']">
		<li class="list-results__item">
            <xsl:apply-templates select="." mode="header"/>
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="key-info"/>
            <xsl:apply-templates select="." mode="abstract"/>
            
            <xsl:call-template name="hit-subprograms"/>
            <xsl:call-template name="hit-subprograms-others"/>
            
            <xsl:call-template name="hit-actions"/>
		</li>
	</xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="header">
        <xsl:call-template name="hit-domain"/>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer' or @saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="title">
        <h2 class="list-results__item__title">
            <xsl:choose>
                <xsl:when test="not(uri)">
                    <xsl:value-of select="title"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="." mode="title-link"/>
                </xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="key-info">
        <section class="program-meta" aria-labelledby="meta-title">
            <h2 id="meta-title" class="sr-only">Informations clés</h2>
            
            <dl class="meta-list">
                <xsl:apply-templates select="content/educationLevel"  mode="meta-item"/><!-- Niveau de diplôme -->
                <xsl:apply-templates select="content/duration"  mode="meta-item"/><!-- Durée -->
                <xsl:apply-templates select="content/orgUnit"  mode="meta-item"/><!-- Composante -->
            </dl>
        </section>
    </xsl:template>
    
    <xsl:template match="*" mode="meta-item">
        <div class="meta-item">
            <div class="icon-container">
                <xsl:apply-templates select="." mode="meta-item-icon"/>
            </div>    
            <div class="meta-text">
                <dt>
                    <xsl:apply-templates select="." mode="meta-item-label"/>
                </dt>
                <dd>
                    <xsl:apply-templates select="." mode="meta-item-value"/>
                </dd>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'orgUnit']" mode="meta-item-label">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HIT_ORGUNIT" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'educationLevel']" mode="meta-item-label">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HIT_DEGREE_LEVEL" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'duration']" mode="meta-item-label">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HIT_DURATION" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'ects']" mode="meta-item-label">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HIT_ECTS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'nbHours']" mode="meta-item-label">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HIT_NB_HOURS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="*" mode="meta-item-value">
        <xsl:choose>
            <xsl:when test="@typeId = 'content'"><xsl:value-of select="@title"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'nbHours']" mode="meta-item-value">
        <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="."/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$nbHours"/>h
    </xsl:template>    
    
    <xsl:template match="*[local-name() = 'ects']" mode="meta-item-value">
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="."/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>                       
    
    <xsl:template match="*[local-name() = 'orgUnit']" mode="meta-item-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'educationLevel']" mode="meta-item-icon">
        <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M1 9.75C0.585786 9.75 0.25 10.0858 0.25 10.5C0.25 10.9142 0.585786 11.25 1 11.25V9.75ZM13.5303 11.0303C13.8232 10.7374 13.8232 10.2626 13.5303 9.96967L8.75736 5.1967C8.46447 4.90381 7.98959 4.90381 7.6967 5.1967C7.40381 5.48959 7.40381 5.96447 7.6967 6.25736L11.9393 10.5L7.6967 14.7426C7.40381 15.0355 7.40381 15.5104 7.6967 15.8033C7.98959 16.0962 8.46447 16.0962 8.75736 15.8033L13.5303 11.0303ZM1 10.5V11.25H13V10.5V9.75H1V10.5Z" fill="#521C7E"></path>
            <path d="M8 1.5H10C14.9706 1.5 19 5.52944 19 10.5C19 15.4706 14.9706 19.5 10 19.5H8" stroke="#521C7E" stroke-width="1.5" stroke-linecap="round"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'duration' or local-name() = 'nbHours']" mode="meta-item-icon">
        <svg width="11" height="18" viewBox="0 0 11 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M10.8 18L10.791 12.6L7.2 9L10.791 5.391L10.8 0H0V5.4L3.6 9L0 12.591V18H10.8ZM1.8 4.95V1.8H9V4.95L5.4 8.55L1.8 4.95Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="*[local-name() = 'ects']" mode="meta-item-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer' or @saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="abstract">
        <xsl:if test="excerpt">
            <p class="list-results__item__description">
                <xsl:value-of select="excerpt"/>
            </p>
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="hit-domain">
        <xsl:if test="content/domain">
            <div class="list-results__item__category">
                <xsl:for-each select="content/domain">
            		<xsl:value-of select="@title"/>
                    <xsl:if test="position() != last()"> | </xsl:if>
                </xsl:for-each>
            </div>
        </xsl:if>
	</xsl:template>

	<xsl:template name="hit-actions">
		<div class="list-results__item__actions">
            <xsl:call-template name="hit-action-share"/>
			<xsl:call-template name="hit-action-download"/>
            <xsl:call-template name="hit-action-save"/>
		</div>
	</xsl:template>
    
	<xsl:template name="hit-action-save">
        <xsl:param name="addTextKey" select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_CART_ADD')"/>
        <xsl:param name="removeTextKey" select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_CART_DELETE')"/>
        
        <button class="btn btn-primary btn-like" id="save-{generate-id()}">
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_CART_ADD" i18n:catalogue="skin.{$skin}"/>
        </button>
        
		<script>
            function _updateStatus<xsl:value-of select="generate-id()"/>(answer)
            {
                let $btn = j('#save-<xsl:value-of select="generate-id()"/>');
                if (answer)
                {
                    $btn.html("<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_CART_DELETE" i18n:catalogue="skin.{$skin}"/>")
                }
            }
            
            ODFCart.hasItem('<xsl:value-of select="id"/>', _updateStatus<xsl:value-of select="generate-id()"/>);
        </script>
	</xsl:template>
	
	<xsl:template name="hit-action-share">
        <button class="btn btn-primary btn-share">
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAM_SHARE" i18n:catalogue="skin.{$skin}"/>
        </button>
	</xsl:template>
	
	<xsl:template name="hit-action-download">
        <xsl:variable name="educationalBooklet" select="odf:getEducationalBooklet(content/@id)"/>
        <div class="btn-download-group">
            <button class="btn btn-primary btn-download" type="button">
                <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAM_DOWNLOAD" i18n:catalogue="skin.{$skin}"/>
            </button>
            
            <xsl:variable name="pdfHref" select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', content/@name, '/main-orientation/', filename:filterName(title), '.pdf')"/>
            
            <div class="btn-download-dropdown">
                <ul>
                    <li><a href="{url:encodePath($pdfHref)}"><i18n:text i18n:key="PROGRAM_DOWNLOAD_PDF" i18n:catalogue="skin.{$skin}"/></a></li>
                    <xsl:if test="$educationalBooklet">
                        <li><a href="{resolver:resolve($educationalBooklet/@type, concat($educationalBooklet/@path, '?objectId=', content/@id), 'true')}"><i18n:text i18n:key="PROGRAM_DOWNLOAD_EDUCATIONAL_BOOKLET" i18n:catalogue="skin.{$skin}"/></a></li>
                    </xsl:if>
                </ul>
            </div>
        </div>
	</xsl:template>
	
    <xsl:template name="hit-subprograms">
        <xsl:if test="$displaySubProgram != 'none' and subprogram">
            <xsl:if test="subprogram[not(@highlight) or @highlight = 'true']">
                <ul class="list-results__item__list">
                    <xsl:for-each select="subprogram[not(@highlight) or @highlight = 'true']">
                        <xsl:call-template name="hit-subprogram" />
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprogram">
        <li>
            <xsl:choose>
                <xsl:when test="not(../uri)">
                    <span><xsl:value-of select="@title"/></span>
                </xsl:when>
                <xsl:otherwise>
                    <a>
                        <xsl:attribute name="href">
                            <xsl:call-template name="hit-href">
                                <xsl:with-param name="url" select="concat(../uri, @path)"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:value-of select="@title"/>
                     </a>
                </xsl:otherwise>
            </xsl:choose>
         </li>
    </xsl:template>
    
   <xsl:template name="hit-subprograms-others">    
        <xsl:if test="$displaySubProgram = 'all_with_highlight' and subprogram[@highlight = 'false']">
            <ul class="list-results__item__list with-line ametys-other-subprogram-{generate-id()}">
                <xsl:for-each select="subprogram[@highlight = 'false']">
                   <xsl:call-template name="hit-subprogram" />
                </xsl:for-each>
            </ul>
            <xsl:call-template name="hit-subprograms-others-button"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprograms-others-button">
    	<div class="btn-arrow-more">
			<button class="btn-arrow" type="button"
                    i18n:attr="data-close-text data-open-text"
			        data-read-more="ametys-other-subprogram-{generate-id()}">
			        <xsl:attribute name="data-open-text">
			        	<xsl:choose>
							<xsl:when test="subprogram[@highlight = 'true']">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_OTHERS</xsl:when>
							<xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_ALL</xsl:otherwise>
						</xsl:choose>
			        </xsl:attribute>
			        <xsl:attribute name="data-close-text">
			        	<xsl:choose>
							<xsl:when test="subprogram[@highlight = 'true']">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_HIDE_OTHERS</xsl:when>
							<xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_HIDE_ALL</xsl:otherwise>
						</xsl:choose>
			        </xsl:attribute>
					<xsl:choose>
						<xsl:when test="subprogram[@highlight = 'true']">
							<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_OTHERS" i18n:catalogue="skin.{$skin}"/>
						</xsl:when>
						<xsl:otherwise>
							<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_ALL" i18n:catalogue="skin.{$skin}"/>
						</xsl:otherwise>
					</xsl:choose>
			</button>
		</div>
    </xsl:template>
    
    <!-- Courses -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']">
        <li class="list-results__item">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="key-info"/>
            <xsl:apply-templates select="." mode="abstract"/>
            
            <xsl:call-template name="hit-actions"/>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="key-info">
        <section class="program-meta" aria-labelledby="meta-title">
            <h2 id="meta-title" class="sr-only">Informations clés</h2>
            
            <dl class="meta-list">
                <xsl:apply-templates select="content/ects"  mode="meta-item"/><!-- Niveau de diplôme -->
                <xsl:apply-templates select="content/nbHours"  mode="meta-item"/><!-- Durée -->
                <xsl:apply-templates select="content/orgUnit"  mode="meta-item"/><!-- Composante -->
            </dl>
        </section>
    </xsl:template>
    
    
</xsl:stylesheet>