<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>         
    <xsl:import href="plugin:odf-web://pages/services/search-v2/hit-program.xsl"/>
    <xsl:import href="plugin:odf-web://pages/services/search-v2/hit-course.xsl"/>
    
    <xsl:import href="skin://services/web/pages/services/search/default/criteria.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/search-map.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/search-results.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/facets.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/pagination.xsl"/>
    
    <xsl:variable name="callback-function">initSearchResults</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search-content/search-content.css')}"/>    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/hero-search/hero-search.css')}"/>    
        <!-- Leaflet CSS -->
        <link rel="stylesheet" href="{ametys:pluginResourceURL('leaflet', 'css/leaflet.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-service-head-js"/>
        
    	<script type="text/javascript" src="{ametys:skinURL('templates/common/js/select.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/mobile-sidebar.js')}"></script>
        
        <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/skins/', ametys:skin(), '/resources/zones/search-content/search.', ametys:lang(), '.js')}"/>
        
        <script type="text/javascript" src="{ametys:pluginResourceURL('odf-web', 'js/cart/Cart.js')}"></script>
        
         <!-- Leaflet JS -->
        <script src="{ametys:pluginResourceURL('leaflet', 'js/leaflet.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/ametys-marker.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('zones/search-content/search-map.js')}"></script>
        
        <script>
            $j(function() {
                initSearchResults();
            })
        </script>
    </xsl:template>
    
    <xsl:variable name="common-service-css-class-name">search-page view-main</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:call-template name="search-main-header"/>
    	<xsl:call-template name="search-main-content"/>
    </xsl:template>
    
    <xsl:template name="search-main-header">
        <div class="hero-search">
            <div class="container">
                <div class="hero__form">
                    <xsl:call-template name="search-main-header-title"/>
                    <xsl:call-template name="form-criteria"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="search-main-header-title">
        <h1 class="hero__title"><xsl:value-of select="$header"/></h1>
    </xsl:template>
    
    <xsl:template name="search-main-content">
        <div class="search-page">
            <div class="container" data-ametys-search-role="search-results">
                <xsl:call-template name="search-sidebar"/>
                <xsl:call-template name="search-results"/>
                
                <div class="search-map-dialog-overlay" data-search-map-dialog-overlay="" style="display: none;"></div>
                <xsl:call-template name="search-map-dialog"/>
                <xsl:call-template name="search-map-js"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="search-sidebar">
        <div class="sidebar-overlay"></div>
        <div class="sidebar">
            <div class="ametys-search-sidebar-inner">
                <xsl:call-template name="search-map"/>
                <xsl:call-template name="facet-filter"/>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>