<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/header/criteria.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">hero</xsl:variable>

    <xsl:variable name="header" select="ametys:serviceParameter('header')"/>
    <xsl:variable name="formTitle" select="ametys:serviceViewParameter('formTitle')"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/hero/hero.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/select.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div class="hero-bg"></div>
        <div class="container">
            <xsl:call-template name="hero-left"/>
            <xsl:call-template name="hero-right"/>
        </div>
    </xsl:template>
    
    <xsl:template name="hero-left">
        <div class="hero__left">
            <xsl:if test="normalize-space($header) != ''">
                <h2 class="hero__title"><xsl:value-of select="$header"/></h2>
            </xsl:if>
    
            <div class="hero__cta">
                <xsl:call-template name="link-tag"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag-icon"/>
            <a class="btn btn-primary">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <xsl:call-template name="link-title-attribute"/>
                <xsl:call-template name="link-attribute"/>
                <xsl:call-template name="link-title"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-default-title">
        <xsl:value-of select="ametys:pageTitle(/search/link/page)"/>
    </xsl:template>
    
    <xsl:template name="link-tag-icon">
        <svg width="140" height="119" viewBox="0 0 140 119" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="svg-deco" aria-hidden="true"
            focusable="false">
            <rect x="30.2383" width="118.508" height="79.0053" transform="rotate(22.504 30.2383 0)" fill="url(#pattern0_5468_34415)"></rect>
            <defs>
                <pattern id="pattern0_5468_34415" patternContentUnits="objectBoundingBox" width="1" height="1">
                    <use xlink:href="#image0_5468_34415" transform="scale(0.00166667 0.0025)"></use>
                </pattern>
                <image id="image0_5468_34415" width="600" height="400" preserveAspectRatio="none"
                    xlink:href="data:image/png;base64,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"></image>
            </defs>
        </svg>
    </xsl:template>
    
    <xsl:template name="hero-right">
        <div class="hero__right">
            <xsl:if test="normalize-space($formTitle) != ''">
                <h2 class="hero__title">
                    <xsl:value-of select="$formTitle"/>
                </h2>
            </xsl:if>
            <xsl:call-template name="form-criteria"/>
        </div>
    </xsl:template>
    
</xsl:stylesheet>