<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
		exclude-result-prefixes="ametys">
	
    <xsl:import href="plugin:web://pages/services/sitemap/sitemap_3.3.xsl"/>			
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
		<link rel="stylesheet" href="{ametys:skinURL('zones/sitemap/sitemap.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
		<script src="{ametys:skinURL('zones/sitemap/sitemap.js')}"></script>
    </xsl:template>
    
    <xsl:template name="page-list">
        <xsl:if test="/sitemap/page">
            <nav aria-label="Plan du site" class="sitemap-nav">
                <ul class="sitemap">
                    <xsl:apply-templates select="/sitemap/page"/>
                </ul>
            </nav>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template match="page[page]">
        <li class="sitemap__item sitemap__item--has-children">
            <div class="sitemap__item-content">
                <button class="sitemap__toggle"
                        aria-expanded="false"
                        aria-label="{@title}"
                        aria-controls="subpages-{generate-id()}">
                </button>
                <a class="sitemap__link" href="{resolver:resolve('page', @id)}" title="{@long-title}"><xsl:value-of select="@title"/></a>
            </div>
            <ul id="subpages-{generate-id()}" hidden="true">
                <xsl:apply-templates select="page"/>
            </ul>
        </li>
    </xsl:template>
    
    <xsl:template match="page">
		<li class="sitemap__item">
		  <a class="sitemap__link" href="{resolver:resolve('page', @id)}" title="{@long-title}"><xsl:value-of select="@title"/></a>
		</li>
	</xsl:template>
    
</xsl:stylesheet>		
