<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
							exclude-result-prefixes="ametys resolver docbook"
							xmlns:datetime="http://ametys.org/datetime/4.2"
                            extension-element-prefixes="datetime">

	<xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/dates.xsl"/>		
	
	<xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
    
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:call-template name="common-content-body-content"/>
        </a>
    </xsl:template>
    
	<xsl:template name="common-content-body-content">
		<xsl:call-template name="content-image"/>
        
        <div class="news__item__content">
             <xsl:call-template name="content-date"/>
             <xsl:call-template name="content-title"/>
        </div>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h2 class="news__item__content__title"><xsl:value-of select="metadata/title"/></h2>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:param name="image" select="metadata/illustration/image"/>
        
        <xsl:if test="$image">
            <div class="news__item__picture">
                <picture>
                    <img src="{resolver:resolveCroppedImage($image/@type, $image/@path, '200', '298')}" alt=""/>
                </picture>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-date">
        <xsl:param name="date" select="metadata/startDate"/>
        
        <xsl:if test="$date">
            <xsl:call-template name="dates">
                <xsl:with-param name="className">news__item__content__date</xsl:with-param>
                <xsl:with-param name="startDate" select="metadata/startDate"/>
                <xsl:with-param name="showTime">false</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
