<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:cms="http://ametys.org/cms/3.0"
                xmlns:exslt="http://exslt.org/common"
                xmlns:docbook="http://docbook.org/ns/docbook"
                exclude-result-prefixes="docbook ametys resolver cms exslt">    
    
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/variables.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <!-- Set to true to display a default image when there is no illustration -->
    <xsl:variable name="useDefaultImage">false</xsl:variable>
    
    <xsl:variable name="wrapperContentCssClass">item actu-item</xsl:variable>
    
    <xsl:template name="common-content-body-title-content"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a class="{$wrapperContentCssClass}" href="{resolver:resolve('page', $page-id, false)}">
                    <xsl:call-template name="content"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <div class="{$wrapperContentCssClass}">
                    <xsl:call-template name="content"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>     
    
    <xsl:template name="content">
        <div class="content">
            <xsl:call-template name="content-tags"/>
            
            <xsl:call-template name="content-icon"/>
            
            <xsl:call-template name="content-title"/>
            
            <xsl:call-template name="content-abstract"/>
            
            <xsl:call-template name="content-image"/>
            
            <xsl:call-template name="content-date"/>
        </div>
    </xsl:template>
    
     <xsl:template name="content-tags">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:if test="exslt:node-set($tags)/tag">
            <div class="etiquettes">
                <xsl:variable name="firstTag" select="exslt:node-set($tags)/tag[position() = '1']"/>
                <span class="etiquette">
                    <xsl:if test="$useTagColor and $firstTag/@bgColor">
                        <xsl:attribute name="style">background-color: <xsl:value-of select="$firstTag/@bgColor"/>; color: <xsl:value-of select="$firstTag/@textColor"/></xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="$firstTag" />
               </span>
                   
    	       <xsl:variable name="remainCount" select="count(exslt:node-set($tags)/tag) - 1"/>
                  <xsl:if test="$remainCount &gt; 0">
                    <xsl:variable name="tooltip">
                        <xsl:for-each select="exslt:node-set($tags)/tag[position() &gt; 1]">
                            <xsl:value-of select="."/>
                            <xsl:if test="position() != last()">, </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    <span class="etiquette" data-tippy-content="{$tooltip}">+ <xsl:value-of select="$remainCount"/></span>
                  </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-icon">
    </xsl:template>
    
    <xsl:template name="content-title">
        <h1 class="item-title actu-item-title">
            <xsl:value-of select="metadata/title"/>
        </h1>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:if test="metadata/abstract or cms:isNotRichTextEmpty(metadata/content)">
            <xsl:call-template name="common-content-body-simpletext">
                <xsl:with-param name="css-class-name">content-abstract</xsl:with-param>
                <xsl:with-param name="text" select="metadata/abstract" />
                <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
                <xsl:with-param name="maxDefaultTextSize" select="70" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:param name="image" select="metadata/illustration/image"/>
        <xsl:param name="alt" select="metadata/illustration/alt-text"/>
        
        <xsl:if test="$image or $useDefaultImage='true'">
            <div class="image-wrapper">
                 <xsl:choose>
                    <xsl:when test="$image">
                        <xsl:variable name="imgUrl" select="resolver:resolveCroppedImage($image/@type, $image/@path, 125, 180)"/>
                        <xsl:attribute name="style">background-image: url(<xsl:value-of select="ametys:escapeURLforCSS($imgUrl)"/>);</xsl:attribute>
                        <!-- Image -->
                        <xsl:call-template name="common-content-body-image">
                            <xsl:with-param name="image" select="$image"/>
                            <xsl:with-param name="alternative" select="$alt"/>
                            <xsl:with-param name="maxWidth" select="'180'"/>
                            <xsl:with-param name="maxHeight" select="'125'"/>
                            <xsl:with-param name="type" select="'cropped'"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="content-default-image"/>
                    </xsl:otherwise>
                </xsl:choose>
                
                <xsl:call-template name="content-date"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <xsl:attribute name="style">background-image: url('<xsl:value-of select="ametys:skinURL('templates/common/img/default-article-image.png')"/>');</xsl:attribute>
        <xsl:call-template name="content-default-image-picto"/>
        <img src="{ametys:skinURL('templates/common/img/default-article-image.png')}" alt="" />
    </xsl:template>
    
    <xsl:template name="content-default-image-picto">
        <i class="far fa-file-alt"></i>
    </xsl:template>
    
    <xsl:template name="content-date"/>
</xsl:stylesheet>    