<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:math="java.lang.Math"
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf docbook math cms exslt">

    <xsl:import href="skin://stylesheets/content/common/zones/key-info.xsl"/>
    
    <!-- +  
         | Template for aside information
         | Display information depends on "aside" fieldset. By default display in order :
         | * testimonies
         | * key information
         | * geocode
         | * contacts
         | * partners
         + -->
    <xsl:template match="fieldset[@name='aside']" mode="display">
        <xsl:variable name="self" select="."/>
   
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <div class="ametys-formation-section__col">
                <xsl:apply-templates select="fieldset|metadata" mode="display"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='contacts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and $value/entry/persons">
            <div class="ametys-sidebar-el">
                <h3 class="ametys-sidebar-title"><xsl:value-of select="label"/></h3>
                
                <div class="ametys-contacts">
                    <xsl:for-each select="$value/entry">
                        <xsl:variable name="role" select="role"/>
                        
                        <xsl:apply-templates select="persons" mode="contact">
                            <xsl:with-param name="role" select="$role"/>
                        </xsl:apply-templates>
                        
                    </xsl:for-each>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="persons" mode="contact">
        <xsl:param name="role"/>
        
        <div class="ametys-contacts__item">
            <xsl:apply-templates select="." mode="contact-avatar"/>
            
            <div class="ametys-contacts__item-content">
                <xsl:apply-templates select="." mode="contact-title"/>
                
                <xsl:call-template name="contact-role">
                    <xsl:with-param name="role" select="$role"/>
                </xsl:call-template>
                
                <xsl:apply-templates select="." mode="contact-phone"/>
                <xsl:apply-templates select="." mode="contact-mail"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="persons" mode="contact-avatar">
        
        <xsl:variable name="imgUri">
            <xsl:call-template name="get-image-uri-from-attribute">
                <xsl:with-param name="id" select="@id"/>
                <xsl:with-param name="attributePath" select="'avatar'"/>
                <xsl:with-param name="height" select="150"/>
                <xsl:with-param name="width" select="150"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="$imgUri != ''">
            <div class="ametys-contacts__item-picture">
                <img src="{$imgUri}" alt="" />
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="persons" mode="contact-title">
        <h4 class="ametys-contacts__item-title">
            <xsl:choose>
                <xsl:when test="givenName != '' and lastName != ''">
                    <xsl:value-of select="concat(givenName, ' ', lastName)"/>
                </xsl:when>
                <xsl:when test="lastName != ''">
                    <xsl:value-of select="lastName"/>
                </xsl:when>
                <xsl:when test="givenName != ''">
                    <xsl:value-of select="givenName"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="title"/>
                </xsl:otherwise>
            </xsl:choose>
        </h4>
    </xsl:template>
    
    <xsl:template name="contact-role">
        <xsl:param name="role"/>
        
        <xsl:if test="$role">
            <p><xsl:value-of select="$role/@title"/></p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="persons" mode="contact-mail">
        <xsl:if test="mail != ''">
            <xsl:call-template name="mail-antispam">
                <xsl:with-param name="mail" select="mail"/>
                <xsl:with-param name="class" select="'mailto'"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="persons" mode="contact-phone">
        <xsl:if test="phone != ''">
            <a href="tel:{phone}" class="phone">
                <xsl:value-of select="phone"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Default template to display a map based on geoCode attribute.
         | If geoCode attribute is empty, switch to coordinates of 'campus' attribute 
         | and if empty, switch to coordinates of 'place' attribute
         + -->
    <xsl:template match="metadata[@name = 'geoCode']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="rawMarkers">
            <xsl:call-template name="content-geocode-marker">
                <xsl:with-param name="data" select="/view/content/metadata"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="markers" select="exslt:node-set($rawMarkers)"/>
                
        <xsl:if test="$markers/markers/marker">
            <xsl:call-template name="leaflet-map">
                <xsl:with-param name="markers" select="$markers"/>
                <xsl:with-param name="title">
                    <xsl:choose>
                        <xsl:when test="count($markers/markers/marker) &gt; 1"><i18n:text i18n:key="PROGRAM_LOCATIONS" i18n:catalogue="skin.{$skin}"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="PROGRAM_LOCATION" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>       
    </xsl:template>
    
    <!-- +
         | Template to display markers on a Leaflet map.
         | 'markers' parameter is mandatory, it contains the marker with latitude (@lat), longitude (@lng) and optionally a title to display in popup (@title)
         + -->
    <xsl:template name="leaflet-map">
        <xsl:param name="markers"/>
        <xsl:param name="title"><i18n:text i18n:key="PROGRAM_LOCATION" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="mapId" select="concat('map-', substring-after(math:random(), '.'))"/>
        <xsl:param name="zoom">13</xsl:param>
        <xsl:param name="height">290</xsl:param>
        
        <xsl:if test="$markers/markers/marker">
            <div class="ametys-sidebar-el">
                <h2 class="ametys-sidebar-title"><xsl:copy-of select="$title"/></h2>
                
                <div class="ametys-map" id="{$mapId}" style="height: {$height}px"></div>
                
                <script type="text/javascript">
                    var latitude = <xsl:value-of select="$markers/markers/marker/@lat"/>;
                    var longitude = <xsl:value-of select="$markers/markers/marker/@lng"/>;
                    
                    var mymap = L.map('<xsl:value-of select="$mapId"/>').setView([latitude, longitude], <xsl:value-of select="$zoom"/>);
                    
                    // Use OpenStreetMap as tile provider
                    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        maxZoom: 19,
                        attribution: '&amp;copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
                    }).addTo(mymap);;
    
                     var latLngs = [];
                    <xsl:for-each select="$markers/markers/marker">
                        var marker = L.marker([<xsl:value-of select="@lat"/>, <xsl:value-of select="@lng"/>], {icon: new AmetysMarkers.Icon({})});
                        marker.addTo(mymap);
                        
                        <xsl:if test="@title != ''">
                            marker.bindPopup("<xsl:value-of select="@title"/>");
                        </xsl:if>
                        latLngs.push(marker.getLatLng());
                    </xsl:for-each>
                    
                      if (latLngs.length > 1)
                      {
                            // Center and zoom the map on all markers
                            var markerBounds = L.latLngBounds(latLngs);
                            mymap.fitBounds(markerBounds);
                      }
                </script>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>