<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf escaper cms">

    <xsl:template name="main-banner-benefits">
        <xsl:apply-templates select="/view/contentType[@view='main-orientation']/fieldset[@name='benefits']" mode="display"/>
    </xsl:template>
    
    <xsl:template match="fieldset[@name = 'benefits']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section class="program-meta" aria-labelledby="meta-title">
                <h2 id="meta-title" class="sr-only"><xsl:value-of select="label"/></h2>
                
                <dl class="meta-list">
                    <xsl:apply-templates select="metadata" mode="benefits" />
                </dl>
            </section>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'keywords']" mode="benefits">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="content" select="/view/content"/><!-- Use for benefits displayed in popup -->
        
        <xsl:if test="$value">
            <div class="meta-item">
                <div class="icon-container">
                    <xsl:apply-templates select="." mode="benefits-icon"/>
                </div>
                <xsl:variable name="definition" select="."/>
                
                 <div class="meta-text">
                    <dt><xsl:value-of select="label"/></dt>
                    
                    <dd class="keywords-wrapper">
                        <span class="keywords-visible">
                            <xsl:for-each select="$value[position() &lt;= 3]">
                                <xsl:if test="position() != 1">, </xsl:if>
                                <xsl:apply-templates select="$definition" mode="benefits-value">
                                    <xsl:with-param name="value" select="."/>
                                    <xsl:with-param name="content" select="$content"/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </span>
                        <xsl:if test="$value[position() &gt; 3]">
                            <div class="keywords-dropdown-group">
                                <button type="button" class="more-keyword" aria-expanded="false">
                                    <xsl:choose>
                                        <xsl:when test="count($value[position() &gt; 3]) = 1">
                                            <i18n:text i18n:key="PROGRAM_KEYWORDS_MORE_SINGLE" i18n:catalogue="skin.{$skin}"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <i18n:translate>
                                                <i18n:text i18n:key="PROGRAM_KEYWORDS_MORE_PLURAL" i18n:catalogue="skin.{$skin}"/>
                                                <i18n:param><xsl:value-of select="count($value[position() &gt; 3])"/></i18n:param>
                                            </i18n:translate>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </button>
                                <div class="keywords-dropdown" aria-hidden="true">
                                    <div class="keywords-dropdown__content">
                                        <xsl:for-each select="$value[position() &gt; 3]">
                                            <xsl:if test="position() != 1">, </xsl:if>
                                            <xsl:apply-templates select="$definition" mode="benefits-value">
                                                <xsl:with-param name="value" select="."/>
                                                <xsl:with-param name="content" select="$content"/>
                                            </xsl:apply-templates>
                                        </xsl:for-each>
                                    </div>
                                </div>
                            </div>
                       </xsl:if>
                  </dd>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="content" select="/view/content"/><!-- Use for benefits displayed in popup -->
        
        <xsl:if test="($value and @type != 'content') or ($value/@id and @type = 'content')">
            <div class="meta-item">
                <div class="icon-container">
                    <xsl:apply-templates select="." mode="benefits-icon"/>
                </div>
                <xsl:variable name="definition" select="."/>
                
                 <div class="meta-text">
                    <dt><xsl:value-of select="label"/></dt>
                    <dd>
                        <xsl:for-each select="$value">
                            <xsl:if test="position() != 1">, </xsl:if>
                            <xsl:apply-templates select="$definition" mode="benefits-value">
                                <xsl:with-param name="value" select="."/>
                                <xsl:with-param name="content" select="$content"/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </dd>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'nbHours']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select='format-number($value, "#,##")' />h
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type = 'content']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type  = 'double']" mode="benefits-value">
        <xsl:param name="value"/>
        <xsl:param name="content"/>
        
        <xsl:variable name="currentEcts">
            <xsl:choose>
                <xsl:when test="$content/@path">
                    <!-- ECTS display outside content's page -->
                    <xsl:value-of select="odf:getEcts($content/@id, $content/@path)"/>
                </xsl:when>
                <xsl:otherwise>
                    <!-- ECTS display on content's page -->
                    <xsl:value-of select="odf:getCurrentEcts()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$currentEcts"/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <!-- FIXME Missing SVG -->
    <!--<xsl:template match="metadata[@name = 'orgUnit']" mode="benefits-icon">
    </xsl:template-->
    
    <!-- FIXME Missing SVG -->
    <!-- xsl:template match="metadata[@name = 'educationLanguage']" mode="benefits-icon">
        <span class="ametys-icon-globe"></span>
    </xsl:template-->
    
    <xsl:template match="metadata[@name = 'educationLevel']" mode="benefits-icon">
        <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M1 9.75C0.585786 9.75 0.25 10.0858 0.25 10.5C0.25 10.9142 0.585786 11.25 1 11.25V9.75ZM13.5303 11.0303C13.8232 10.7374 13.8232 10.2626 13.5303 9.96967L8.75736 5.1967C8.46447 4.90381 7.98959 4.90381 7.6967 5.1967C7.40381 5.48959 7.40381 5.96447 7.6967 6.25736L11.9393 10.5L7.6967 14.7426C7.40381 15.0355 7.40381 15.5104 7.6967 15.8033C7.98959 16.0962 8.46447 16.0962 8.75736 15.8033L13.5303 11.0303ZM1 10.5V11.25H13V10.5V9.75H1V10.5Z" fill="#521C7E"></path>
            <path d="M8 1.5H10C14.9706 1.5 19 5.52944 19 10.5C19 15.4706 14.9706 19.5 10 19.5H8" stroke="#521C7E" stroke-width="1.5" stroke-linecap="round"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects']" mode="benefits-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']" mode="benefits-icon">
        <svg width="11" height="18" viewBox="0 0 11 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M10.8 18L10.791 12.6L7.2 9L10.791 5.391L10.8 0H0V5.4L3.6 9L0 12.591V18H10.8ZM1.8 4.95V1.8H9V4.95L5.4 8.55L1.8 4.95Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <!-- xsl:template match="metadata[@name = 'teachingTerm']" mode="benefits-icon">
        <span class="far fa-calendar-alt"></span>
    </xsl:template-->
    
    <!-- Default icon for benefits -->
    <xsl:template match="metadata" mode="benefits-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
</xsl:stylesheet>