<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf cms">
    
    <xsl:template match="fieldset[@name = 'key-info']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <div class="ametys-sidebar-el">
												
				<h3 class="ametys-sidebar-title"><xsl:value-of select="label"/></h3>
				
				<dl class="meta-list">
					<xsl:apply-templates select="metadata" mode="key-info" />
                </dl>
            </div>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'content']" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and $value/@id">
            <xsl:apply-templates select="." mode="key-info-row">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and $value != ''">
            <xsl:apply-templates select="." mode="key-info-row">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info-row">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <div class="meta-item">
            <xsl:apply-templates select="." mode="key-info-icon"/>
            
            <div class="meta-text">
                <dt><xsl:value-of select="label"/></dt>
                <dd>
                    <xsl:apply-templates select="$definition" mode="key-info-value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </dd>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info-value">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:for-each select="$value">
            <xsl:if test="position() != 1"><br/></xsl:if>
            <xsl:apply-templates select="$definition" mode="value">
                <xsl:with-param name="value" select="."/>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'erasmusCode']|metadata[@name = 'romeCode']|metadata[@name = 'fapCode']|metadata[@name = 'nsfCode']|metadata[@name = 'siseCode']|metadata[@name = 'dgesipCode']" mode="key-info-icon">
        <svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.19434 1.96582L3.32031 6.55371L7.19434 11.1406L5.53418 13.1064L0 6.55371L5.53418 0L7.19434 1.96582ZM17.71 6.55371L12.1758 13.1064L10.5156 11.1406L14.3887 6.55371L10.5156 1.96582L12.1758 0L17.71 6.55371Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'place']|metadata[@name = 'campus']|metadata[@name = 'geocode']" mode="key-info-icon">
        <svg width="13" height="21" viewBox="0 0 13 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.08496 19.9219L6.19922 20.9707L5.31445 19.9219V12.583H7.08496V19.9219ZM12.3965 1.04883L9.74023 2.09668V10.4854L12.3965 11.5342V12.583H7.08496V12.582H5.31445V12.583H0V11.5342L2.65625 10.4854V2.09668L0 1.04883V0H12.3965V1.04883Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']|metadata[@name = 'teachingStart']|metadata[@name = 'teachingEnd']|metadata[@name = 'registrationStart']|metadata[@name = 'registrationDeadline']" mode="key-info-icon">
        <span class="icon fas fa-clock"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'speciality']" mode="key-info-icon">
        <span class="icon fas fa-star"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programField']|metadata[@name = 'availableCertification']|metadata[@name = 'formofteachingOrg']" mode="key-info-icon">
        <svg width="16" height="21" viewBox="0 0 16 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.96875 0C10.1891 1.97538 12.9494 3.14551 15.9404 3.14551V11.5332C15.9404 13.8498 14.5522 16.6413 12.8477 17.7627L7.96973 20.9707L3.09277 17.7627C1.38466 16.639 7.69146e-05 13.8461 0 11.5332V3.14355C2.98982 3.14355 5.74885 1.97397 7.96875 0ZM6.93359 8.89258L3.7793 8.96875L6.29395 11.2266L5.37988 14.8037L7.96973 12.6689L10.5605 14.8037L9.64648 11.2266L12.1611 8.96875L9.00586 8.89258L7.96973 5.36328L6.93359 8.89258Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'degree']|metadata[@name = 'mention']|metadata[@name = 'availableCertification']" mode="key-info-icon">
        <svg width="18" height="21" viewBox="0 0 18 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M15.0527 16.5674L8.85449 20.9717L4.42676 17.8262L2.65625 16.5674V10.2764L8.85449 14.6807L15.0527 10.2764V16.5674ZM1.77051 9.64648V14.4463L0 16.7764V8.3877L1.77051 9.64648ZM17.71 6.29102L8.85449 12.583L2.95117 8.38867H8.85449V6.29102H0L8.85449 0L17.71 6.29102Z"></path>
        </svg>
    </xsl:template>
    
    <!-- Default icon for a key information -->
    <xsl:template match="metadata" mode="key-info-icon">
        <svg width="15" height="21" viewBox="0 0 15 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M11.5049 0C11.9973 0 12.3965 0.465692 12.3965 1.04883V2.09668H2.6582C2.1682 2.09696 1.77057 2.56261 1.77051 3.14551C1.77051 3.72445 2.16917 4.19408 2.66211 4.19434H3.54102V12.582L5.31152 10.4854L7.08301 12.582V4.19434H13.2764C13.7687 4.19445 14.168 4.66096 14.168 5.24414V18.8799C14.168 20.0345 13.3758 20.9705 12.4023 20.9707H1.76562C0.790556 20.9706 0.000107691 20.0293 0 18.8838V2.08789C0 0.935025 0.794545 0 1.77637 0H11.5049Z"></path>
        </svg>
    </xsl:template>

</xsl:stylesheet>