<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:math="http://exslt.org/math"
							xmlns:exsl="http://exslt.org/common"
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0" 
							exclude-result-prefixes="ametys resolver cms">

    <xsl:import href="skin://stylesheets/content/default-content.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
	<xsl:import href="skin://stylesheets/content/course/course.xsl"/>
    
    <xsl:import href="skin://stylesheets/content/utils.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/banner.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/benefits.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/aside.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/mcc.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/skills.xsl"/>   
    
    <xsl:template name="common-content-head-additional-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/course/course.css')}" />        
    </xsl:template>
    
    <xsl:template name="common-content-head-other">
        <meta name="ODF.content" content="true"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="main-banner"/>
        <xsl:call-template name="main-content"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <!-- Display tabs -->
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][1]" mode="display-first"/>
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][position() != 1]" mode="display"/>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='tab']" mode="display-first">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section id="tab-{generate-id()}" class="ametys-formation-section two-cols">
                <div class="container">
                    <div class="ametys-formation-section__col ametys-richtext">
                       <h2 class="ametys-formation-title"><xsl:value-of select="label"/></h2>
                    
                        <xsl:apply-templates select="metadata|fieldset[@name != 'aside']" mode="display"/> 
                    </div>
                    
                    <!-- Aside informations -->
                    <xsl:apply-templates select="/view/contentType/fieldset[@name='aside']" mode="display"/> 
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <h3 class="ametys-richtext-title-2"><xsl:value-of select="label"/></h3>
            
            <ul class="ametys-coursepart">
                <xsl:variable name="definition" select="."/>
                <xsl:for-each select="$value">
                    <xsl:apply-templates select="$definition" mode="value">
                        <xsl:with-param name="value" select="."/>
                    </xsl:apply-templates>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="value">
        <xsl:param name="value"/>
        
        <li class="ametys-coursepart__item">
            <span class="ametys-coursepart__item-icon ametys-icon-clock"></span>
            <span class="ametys-coursepart__item-title"><xsl:value-of select="$value/title"/></span>
            <span class="ametys-coursepart__item-text"><xsl:value-of select="$value/nature/@title"/></span>
            
            <span class="ametys-coursepart__item-badge ametys-coursepart__item-badge--total">
                <xsl:if test="$value/nbHours != 0">
                    <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$value/nbHours"/></xsl:call-template></xsl:variable>
                    <xsl:value-of select="$nbHours"/>h
                </xsl:if>
            </span>
        </li>
    </xsl:template>
            
</xsl:stylesheet>
