<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:math="java.lang.Math"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:import href="home-video.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">lame-two-columns view-main</xsl:variable>     
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/text-video/text.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/text-video/video.css')}"/>
       <!--  <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/richtext.css')}"/>  -->  
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script src="{ametys:skinURL('zones/text-video/text-video.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-content-body-title-content"/>
    
	<xsl:template name="common-content-body-content">
        <div class="container">
            <xsl:call-template name="video-description"/>
            <xsl:call-template name="video-content"/>
        </div>
        <xsl:call-template name="video-player"/>
    </xsl:template>
    
    <xsl:template name="video-description">
        <div class="text-content">
            <h1 class="service-title"><xsl:value-of select="metadata/title"/></h1>
            <xsl:call-template name="common-content-body-content-rich" />
        </div>
    </xsl:template>
    
    <xsl:template name="video-content">
        <div class="video-content">
            <xsl:call-template name="video-play-btn"/>
            <xsl:call-template name="video-cover"/>
        </div>
    </xsl:template>
    
    <xsl:template name="video-play-btn">
        <xsl:if test="metadata/video/sourceType/@value = 'YOUTUBE' and metadata/video/youtubeId != ''">
            <button class="play-btn" data-video-id="{metadata/video/youtubeId}" aria-haspopup="dialog" aria-controls="video-lightbox">
                <svg width="19" height="22" viewBox="0 0 19 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                    <path
                        d="M17.4628 8.68652C18.119 9.1084 18.5409 9.8584 18.5409 10.6084C18.5409 11.4053 18.119 12.1553 17.4628 12.5303L3.96276 20.7803C3.25964 21.2021 2.36901 21.249 1.66589 20.8271C0.962761 20.4521 0.540886 19.7021 0.540886 18.8584V2.3584C0.540886 1.56152 0.962761 0.811523 1.66589 0.436523C2.36901 0.0146484 3.25964 0.0146484 3.96276 0.483398L17.4628 8.68652Z"
                        fill="#521C7E"></path>
                </svg>
                <span class="sr-only"><i18n:text i18n:key="SKIN_HOME_VIDEO_PLAY" i18n:catalogue="skin.{$skin}"/></span>
            </button>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="video-player">
        <xsl:if test="metadata/video/sourceType/@value = 'YOUTUBE' and metadata/video/youtubeId != ''">
            <div id="video-lightbox" class="ylightbox" aria-hidden="true" role="dialog" aria-modal="true" aria-labelledby="ylightbox-title">
                <div class="ylightbox__backdrop" data-close=""></div>
                <div class="ylightbox__dialog" role="document">
                    <button class="ylightbox__close" type="button" aria-label="skin.{$skin}:SKIN_HOME_VIDEO_CLOSE" i18n:attr="aria-label" data-close="">×</button>
                    <h2 id="ylightbox-title" class="sr-only">
                        <i18n:text i18n:key="SKIN_HOME_VIDEO_LEGEND" i18n:catalogue="skin.{$skin}"/>
                        <xsl:if test="metadata/video/caption != ''">
                            <xsl:text> - </xsl:text>
                            <xsl:value-of select="metadata/video/caption"/>
                        </xsl:if>
                    </h2>
                    <div class="ylightbox__player" data-player=""></div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="video-src">
        <xsl:param name="video" select="metadata/video/file"/>
        <xsl:value-of select="resolver:resolve($video/@type, $video/@path, false(), true())"/>
    </xsl:template>
    
    <xsl:template name="video-cover">
        <xsl:param name="image" select="metadata/video/coverImage"/>
        <xsl:if test="$image">
            <img src="{resolver:resolveCroppedImage($image/@type, $image/@path, 0, 0)}"/>
        </xsl:if>
    </xsl:template>
	
</xsl:stylesheet>