<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:math="http://exslt.org/math"
							xmlns:exsl="http://exslt.org/common"
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0" 
							exclude-result-prefixes="ametys resolver cms">

    <xsl:import href="skin://stylesheets/content/default-content.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
	<xsl:import href="skin://stylesheets/content/program/program.xsl"/>
    
    <xsl:import href="skin://stylesheets/content/utils.xsl"/>   
    <xsl:import href="skin://stylesheets/content/program/zones/banner.xsl"/>   
    <xsl:import href="skin://stylesheets/content/program/zones/benefits.xsl"/>   
    <xsl:import href="skin://stylesheets/content/program/zones/aside.xsl"/>   
    
    <xsl:template name="common-content-head-additional-css">
        <!-- Leaflet CSS -->
        <link rel="stylesheet" href="{ametys:pluginResourceURL('leaflet', 'css/leaflet.css')}"/>
    </xsl:template> 
    
    <xsl:template name="common-content-head-additional-js">
         <script src="{ametys:skinURL('zones/nav-formation/nav-formation.js')}" defer="true"></script>
         <script src="{ametys:skinURL('zones/hero-formation/hero-formation.js')}" defer="true"></script>
         <script type="text/javascript" src="{ametys:pluginResourceURL('odf-web', 'js/cart/Cart.js')}"></script>
         
         <!-- Leaflet JS -->
         <script type="text/javascript" src="{ametys:pluginResourceURL('leaflet', 'js/leaflet.js')}"></script>
         <script src="{ametys:skinURL('templates/common/js/ametys-marker.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="main-banner"/>
        <xsl:call-template name="main-content"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <!-- Tabs navigation -->
        <xsl:if test="/view/contentType/fieldset[@role = 'tab']">
            <xsl:call-template name="tabs-navigation"/>
        </xsl:if>
            
        <!-- Display tabs -->
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][1]" mode="display-first"/>
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][position() != 1]" mode="display"/>
    </xsl:template>
    
    <!-- +
         | Template for tabs navigation
         + -->
    <xsl:template name="tabs-navigation">
        <nav role="navigation" class="nav-formation" aria-label="Navigation dans la formation" style="top: 140px;">
            <div class="container">
                <ul>
                    <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab']" mode="nav"/>
                </ul>
            </div>
        </nav>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='tab' and @name='program']" mode="nav" priority="100">
        <xsl:variable name="self" select="."/>
        
        <!--  Get all subprograms and all containers of type 'year' among the direct children -->
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildProgramItems" select="count($currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist) &gt; 0"/>
    
        <xsl:if test="cms:isNotFieldsetEmpty($self) or $hasChildProgramItems">
            <li>
                <a href="#tab-{generate-id()}"><xsl:value-of select="label"/></a>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='tab']" mode="nav">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <li>
                <a href="#tab-{generate-id()}"><xsl:value-of select="label"/></a>
            </li>
         </xsl:if>
    </xsl:template>
    
    <!-- +
         | Default template for display of first tab.
         | This tab display information on two columns.
         | A "main" and "aside" fieldsets are expected.
         + -->
    <xsl:template match="fieldset[@role='tab']" mode="display-first">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section id="tab-{generate-id()}" class="ametys-formation-section two-cols">
                <div class="container">
                    <div class="ametys-formation-section__col ametys-richtext">
                       <h2 class="ametys-formation-title"><xsl:value-of select="label"/></h2>
                    
                        <xsl:apply-templates select="metadata|fieldset[@name != 'aside']" mode="display"/> 
                    </div>
                    
                    <!-- Aside informations -->
                    <xsl:apply-templates select="fieldset[@name='aside']" mode="display"/> 
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <!-- **************************************** -->
    <!--                 Alternance               -->
    <!-- **************************************** -->
    <xsl:template match="metadata[@name='apprenticeshipOpen']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value = 'true'">
            <div class="ametys-formation-subsection ametys-richtext">
                <h3 class="ametys-richtext-title-2"><i18n:text i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_OPEN" i18n:catalogue="plugin.odf"/></h3>
                
                <xsl:choose>
                    <xsl:when test="/view/content/metadata/*[local-name() = 'apprenticeshipContract'] or /view/content/metadata/*[local-name() = 'apprenticeshipPeriod']/docbook:article or /view/content/metadata/*[local-name() = 'apprenticeshipModalities']/docbook:article">
                        <xsl:if test="/view/content/metadata/*[local-name() = 'apprenticeshipContract']">
                            <table class="simple" style="width: 100%;">
                                <tbody>
                                    <tr></tr>
                                    <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipContract']" mode="table-row"/>
                                </tbody>
                            </table>
                        </xsl:if>
                
                        <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipPeriod']" mode="apprenticeship"/>
                        
                        <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipModalities']" mode="apprenticeship"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <p><i18n:text i18n:key="PROGRAM_APPRENTICESHIP_OPEN" i18n:catalogue="skin.{$skin}"/></p>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='apprenticeshipContract']" mode="display"/>
    
    <xsl:template match="metadata[@name='apprenticeshipPeriod']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipPeriod']" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
                
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata[@name='apprenticeshipModalities']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipModalities']" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <!-- **************************************** -->
    <!--                 Stage                    -->
    <!-- **************************************** -->
    <xsl:template match="metadata[@name='internshipOpen']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value = 'true' or /view/content/metadata/*[local-name() = 'internshipDescription']/@entryCount != '0'">
            <div class="ametys-formation-subsection ametys-richtext">
                <h3 class="ametys-richtext-title-2"><i18n:text i18n:key="CONTENT_PROGRAM_TRAINING_STRATEGY" i18n:catalogue="plugin.odf"/></h3>
                
                 <xsl:choose>
                    <xsl:when test="/view/content/metadata/*[local-name() = 'internship'] 
                                or /view/content/metadata/*[local-name() = 'internshipDuration'] 
                                or /view/content/metadata/*[local-name() = 'internshipAbroad']
                                or /view/content/metadata/*[local-name() = 'internshipAbroadDuration']
                                or /view/content/metadata/*[local-name() = 'trainingStrategy']/docbook:article">
                    
                            <xsl:if test="/view/content/metadata/*[local-name() = 'internship'] 
                                            or /view/content/metadata/*[local-name() = 'internshipDuration'] 
                                            or /view/content/metadata/*[local-name() = 'internshipAbroad']
                                            or /view/content/metadata/*[local-name() = 'internshipAbroadDuration']">
                                <table class="simple" style="width: 100%;">
                                    <tbody>
                                        <tr></tr>
                                        <xsl:apply-templates select="/view/contentType//metadata[@name='internship']|/view/contentType//metadata[@name='internshipDuration']|/view/contentType//metadata[@name='internship']|/view/contentType//metadata[@name='internshipAbroad']|/view/contentType//metadata[@name='internshipAbroadDuration']" mode="table-row"/>
                                    </tbody>
                                </table>
                            </xsl:if>
                            
                            <xsl:apply-templates select="/view/contentType//metadata[@name='trainingStrategy']" mode="internship"/>
                    </xsl:when>
                    <xsl:when test="not(/view/content/metadata/*[local-name() = 'internshipDescription']) or /view/content/metadata/*[local-name() = 'internshipDescription']/@entryCount = '0'">
                         <p><i18n:text i18n:key="PROGRAM_INTERNSHIP_OPEN" i18n:catalogue="skin.{$skin}"/></p>
                    </xsl:when>
                </xsl:choose>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='trainingStrategy']" mode="display"/>
    <xsl:template match="metadata[@name='trainingStrategy']" mode="internship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata[@name='internship']" mode="display"/>
    <xsl:template match="metadata[@name='internshipDuration']" mode="display"/>
    <xsl:template match="metadata[@name='internshipAbroad']" mode="display"/>
    <xsl:template match="metadata[@name='internshipAbroadDuration']" mode="display"/>
    
    <xsl:template match="metadata[@name='internshipDescription']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and $value/entry/title != ''">
            <xsl:variable name="repeaterDef" select="."/>
             
            <div class="ametys-faq">       
                <xsl:for-each select="$value/entry">
                    <details>
                        <summary><xsl:value-of select="title"/></summary>
                        
                        <xsl:variable name="entry" select="."/>
                        
                        <div class="ametys-richtext">
                            <xsl:for-each select="$repeaterDef/metadata[@name != 'title']">
                                <xsl:variable name="name" select="@name"/>
                                <xsl:apply-templates select="." mode="faq-details">
                                    <xsl:with-param name="value" select="$entry/*[local-name() = $name]"/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </div>
                    </details>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- Répartition poursuite d'étude -->
    <xsl:template match="metadata[@name = 'furtherStudyDistribution']" mode="display">
        <!-- NOT YET IMPLEMENTED -->
    </xsl:template>
            
    <!-- Témoignages -->
    <xsl:template match="metadata[@name = 'testimonies']" mode="display">
        <!-- NOT YET IMPLEMENTED -->
    </xsl:template>
</xsl:stylesheet>
