<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:cms="http://ametys.org/cms/3.0" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:odf="org.ametys.odf.OdfXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:exsl="http://exslt.org/common"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    exclude-result-prefixes="docbook"
    extension-element-prefixes="resolver cms ametys stringutils">
    
    <xsl:import href="plugin:odf://stylesheets/content/program/program2pdf-main.xsl" />
    
    <xsl:import href="skin://stylesheets/content/utils.xsl" />
    <xsl:import href="skin://stylesheets/fo-styling.xsl" />
    
    <xsl:import href="skin://stylesheets/content/default-content2pdf.xsl"/>
    <xsl:import href="skin://stylesheets/content/common2pdf.xsl"/>
    
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <!-- +
         | Determines the page layout
         | * page =>  1 column layout
         | * page-2-columns => 2 columns layout
         + -->
    <xsl:template name="page-layout">page-2-columns</xsl:template>
    
    <!-- +
         | Determines the page layout for structure (course table)
         | * page =>  1 column layout
         | * page-2-columns => 2 columns layout
         | The 'page' layout is recommended when full mode for structure is used
         + -->
    <xsl:template name="structure-page-layout">page</xsl:template>
    
    <!-- +
         | Get the mode of structure table
         | * simple: table with UE title / Credits / Total hours
         | * full: table with UE title / Nature / CM / TD / TP / Credits
         | Note that if full mode is used, it is recommended to use 1 column layout -->
    <xsl:template name="table-structure-mode">full</xsl:template>
    
    <!--+
		+  PAGE CONTENT
		+ -->	
	<xsl:template match="content">
		<xsl:variable name="truelevel" select="1"/>
        
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildProgramItems" select="count($currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist) &gt; 0"/>
		
		<fo:page-sequence>
            <xsl:call-template name="master-reference-attribute"/>
			
            <xsl:call-template name="xsl-region-before"/>
            
            <xsl:call-template name="xsl-region-after"/>
            
	        <!-- Body region -->	
 			<fo:flow flow-name="xsl-region-body">
				<fo:block space-before="1cm" margin-top="0cm" margin-bottom="1cm" margin-left="0cm" margin-right="0cm" span="all">
					  <xsl:call-template name="header"/>
				</fo:block>
                
                <fo:block space-before="1cm"  margin-top="0cm" margin-bottom="1cm" margin-left="0cm" margin-right="0cm" span="all">
                    <!-- Benefits -->
                    <xsl:apply-templates select="/view/contentType/fieldset[@name='benefits']" mode="display"/>
                </fo:block>
				<fo:block>
 					  <xsl:call-template name="main-body-block"/>
 					  <xsl:call-template name="body">
                   		  <xsl:with-param name="truelevel" select="$truelevel"/>
                   	  </xsl:call-template>
			    </fo:block>
                
                <xsl:if test="not(cms:isNotFieldsetEmpty(/view/contentType/fieldset[@role = 'tab' and @name = 'program']) or $hasChildProgramItems)">
                    <fo:block id="theEnd" />
                </xsl:if>
			</fo:flow>
		</fo:page-sequence>
        
        <xsl:if test="cms:isNotFieldsetEmpty(/view/contentType/fieldset[@role = 'tab' and @name = 'program']) or $hasChildProgramItems">
    		<fo:page-sequence>
                <xsl:call-template name="master-reference-attribute-for-structure"/>
                
    			<xsl:call-template name="xsl-region-before"/>
                
                <xsl:call-template name="xsl-region-after"/>
                
    	        <!-- Body region -->	
     			<fo:flow flow-name="xsl-region-body">
     				<fo:block>
     					<xsl:call-template name="main-body-block"/>
    					<xsl:call-template name="bodyProgramPart">
    		               <xsl:with-param name="truelevel" select="$truelevel"/>
    		            </xsl:call-template>
    		        </fo:block>
                    
                    <fo:block id="theEnd" />
    	        </fo:flow>
    		</fo:page-sequence>
        </xsl:if>
	</xsl:template>
    
    <!-- 
        | Set the "master-reference" attribute to determine the page layout:
        | * page-2-columns : 2 columns layout.
        | * page: 1 column layout
        +-->
    <xsl:template name="master-reference-attribute">
        <xsl:attribute name="master-reference"><xsl:call-template name="page-layout"/></xsl:attribute>
    </xsl:template>
    
    <!-- 
        | Set the "master-reference" attribute to determine the page layout for the table structure:
        | * page-2-columns : 2 columns layout.
        | * page: 1 column layout
        +-->
    <xsl:template name="master-reference-attribute-for-structure">
        <xsl:attribute name="master-reference"><xsl:call-template name="structure-page-layout"/></xsl:attribute>
    </xsl:template>
    
    <!-- // Header -->
	<xsl:template name="header">
        <fo:block xsl:use-attribute-sets="header" margin-top="-0.35cm">
            <xsl:call-template name="header-category"/>
            <xsl:call-template name="header-title"/>
            <xsl:call-template name="header-subtitle"/>
        </fo:block>
	</xsl:template>
    <xsl:template name="header-category">
        <xsl:if test="normalize-space(metadata/domain/@title ) != ''">
            <fo:block xsl:use-attribute-sets="header-category">
                <xsl:value-of select="stringutils:upperCase(metadata/domain/@title)"/>
            </fo:block>
        </xsl:if>
    </xsl:template>
    <xsl:template name="header-title">
        <fo:block xsl:use-attribute-sets="header-title">
            <xsl:value-of select="metadata/title"/>
        </fo:block>
    </xsl:template>
    <xsl:template name="header-subtitle">
        <xsl:if test="normalize-space(metadata/mention/@title ) != ''">
            <fo:block xsl:use-attribute-sets="header-subtitle">
                <xsl:value-of select="metadata/mention/@title"/>
            </fo:block>
        </xsl:if>
    </xsl:template>
    <xsl:attribute-set name="header"/>
    <xsl:attribute-set name="header-category"/>
    <xsl:attribute-set name="header-title"/>
    <xsl:attribute-set name="header-subtitle"/>
	<!-- // End Header -->
	
	<xsl:template name="body">
        <xsl:call-template name="body-top"/>
        
        <xsl:call-template name="body-content">
			<xsl:with-param name="truelevel" select="2"/>
		</xsl:call-template>
        
        <xsl:call-template name="body-bottom"/>
    </xsl:template>
	
	<xsl:template name="body-content">
    	<xsl:param name="truelevel"/>
    	
        <!-- // Available subprograms -->
    	<xsl:call-template name="subprogram-list">
    		<xsl:with-param name="truelevel" select="$truelevel"/>
    	</xsl:call-template>

        <!-- // Tab fieldsets except program -->        
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab' and @name != 'program']" mode="display"/>
        
        <!-- // Contacts -->
        <xsl:call-template name="contacts"/>
        
    </xsl:template>
    
    <xsl:template name="contacts">
        <xsl:if test="/view/content/metadata/contacts/@entryCount != '0'  
                or /view/content/metadata/place 
                or /view/content/metadata/campus
                or /view/content/metadata/otherContact 
                or /view/content/metadata/partnerSchools/@entryCount != '0'  
                or /view/content/metadata/otherPartners
                or /view/content/metadata/partnerLaboratories/@entryCount != '0'
                or /view/content/metadata/programWebSite/@entryCount != '0'">
                
            <fo:block xsl:use-attribute-sets="fieldset-title">
                <fo:block xsl:use-attribute-sets="fieldset-title-body">
                    <i18n:text i18n:key="PDF_CONTACT_INFOS" i18n:catalogue="skin.{$skin}"/>
                </fo:block>
            </fo:block>
        
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'contacts']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'otherContact']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'partnerSchools']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'partnerLaboratories']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'otherPartners']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'place']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'campus']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'programWebSite']" mode="display"/>
        </xsl:if>
    </xsl:template>
    
   	<!-- // Custom display for apprenticeship -->
    <xsl:template match="metadata[@name='apprenticeshipOpen']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value = 'true'">
            <fo:block>
                <fo:block xsl:use-attribute-sets="section-title">
                    <i18n:text i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_OPEN" i18n:catalogue="plugin.odf"/>
                </fo:block>
                
                <xsl:if test="/view/content/metadata/*[local-name() = 'apprenticeshipContract']">
                    <fo:block>
                        <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipContract']" mode="apprenticeship"/>
                    </fo:block>
                </xsl:if>
                
                <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipPeriod']" mode="apprenticeship"/>
                <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipModalities']" mode="apprenticeship"/>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='apprenticeshipContract']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipContract']" mode="apprenticeship">
		<xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:inline font-weight="bold"><xsl:value-of select="label"/> : </fo:inline>
            
            <xsl:variable name="definition" select="."/>
            
            <fo:inline>
		        <xsl:for-each select="$value">
		            <xsl:apply-templates select="$definition" mode="value">
	                    <xsl:with-param name="value" select="."/>
	                </xsl:apply-templates>
	                <xsl:choose>
	                	<xsl:when test="position() = last()">.</xsl:when>
	                	<xsl:otherwise>, </xsl:otherwise>
	                </xsl:choose>
		        </xsl:for-each>
	        </fo:inline>
	        <fo:block>&#160;</fo:block>
	    </xsl:if>
	</xsl:template>
    
    <xsl:template match="metadata[@name='apprenticeshipPeriod']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipPeriod']" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    <xsl:template match="metadata[@name='apprenticeshipModalities']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipModalities']" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    <xsl:template match="metadata" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:inline font-weight="bold"><xsl:value-of select="label"/> : </fo:inline>
            <xsl:apply-templates select="." mode="value">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
            <fo:block>&#160;</fo:block>
        </xsl:if>
    </xsl:template>   
    <!-- // End apprenticeship -->
    
    <!-- // Custom display for internship -->
    <xsl:template match="metadata[@name='internshipOpen']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value = 'true'">
            <fo:block>
                <fo:block xsl:use-attribute-sets="section-title">
                    <i18n:text i18n:key="CONTENT_PROGRAM_TRAINING_STRATEGY" i18n:catalogue="plugin.odf"/>
                </fo:block>
                <fo:block xsl:use-attribute-sets="section-body">
                    <xsl:if test="/view/content/metadata/*[local-name() = 'internship'] 
                                or /view/content/metadata/*[local-name() = 'internshipDuration'] 
                                or /view/content/metadata/*[local-name() = 'internshipAbroad']
                                or /view/content/metadata/*[local-name() = 'internshipAbroadDuration']">
                        <fo:block>
                            <xsl:apply-templates select="/view/contentType//metadata[@name='internship']|/view/contentType//metadata[@name='internshipDuration']|/view/contentType//metadata[@name='internship']|/view/contentType//metadata[@name='internshipAbroad']|/view/contentType//metadata[@name='internshipAbroadDuration']" mode="intership"/>
                        </fo:block>
                    </xsl:if>
                    
                    <xsl:apply-templates select="/view/contentType//metadata[@name='trainingStrategy']" mode="trainingStrategy"/>
                </fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='internship']" mode="display"/>
    <xsl:template match="metadata[@name='internshipDuration']" mode="display"/>
    <xsl:template match="metadata[@name='internshipAbroad']" mode="display"/>
    <xsl:template match="metadata[@name='internshipAbroadDuration']" mode="display"/>
    <xsl:template match="metadata[@name='trainingStrategy']" mode="display"/>
    <xsl:template match="metadata[@name='trainingStrategy']" mode="trainingStrategy">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata" mode="intership">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:inline font-weight="bold"><xsl:value-of select="label"/> : </fo:inline>
            <xsl:apply-templates select="." mode="value">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
            <fo:block>&#160;</fo:block>
        </xsl:if>
    </xsl:template>   
    <!-- // End internship -->

    <!-- // List of subprograms -->    
    <xsl:template name="subprogram-list">
       	<xsl:if test="subprogram">
		    <fo:block xsl:use-attribute-sets="subprogram-block">
                <fo:block xsl:use-attribute-sets="subprogram-block-body">
                    <fo:block xsl:use-attribute-sets="subprogram-block-title"><i18n:text i18n:key="PDF_SUBPROGRAM_LIST_TITLE" i18n:catalogue="skin.{$skin}"/></fo:block>
                    <fo:list-block>
    	                <xsl:apply-templates select="subprogram" mode="list"/>
    	            </fo:list-block>
                </fo:block>
	        </fo:block>
        </xsl:if>
	</xsl:template>
	
	<xsl:template match="subprogram" mode="list">
        <fo:list-item>
		  	<fo:list-item-label>
 		  		<fo:block font-family="FontAwesome" font-weight="bold" font-size="7px">&#xf054;</fo:block>
		  	</fo:list-item-label>
		  	<fo:list-item-body start-indent="body-start()-5mm">
		  		<fo:block>
                    <xsl:choose>
                        <xsl:when test="$exportMode = 'educational-booklet'">
                            <fo:basic-link internal-destination="bookmark-subprogram-{@id}"><xsl:value-of select="content/content/metadata/title"/></fo:basic-link>
                        </xsl:when>
                        <xsl:otherwise><xsl:value-of select="content/content/metadata/title"/></xsl:otherwise>
                    </xsl:choose>
                </fo:block>
           </fo:list-item-body>
        </fo:list-item>
	</xsl:template>
    
    <xsl:attribute-set name="subprogram-block"/>
    <xsl:attribute-set name="subprogram-block-body"/>
    <xsl:attribute-set name="subprogram-block-title"/>
    <!-- // End : List of subprograms -->    
    
	
	<!-- // Program table (semesters, courses) -->
	<xsl:template name="bodyProgramPart">
		<xsl:param name="truelevel"/>
        
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildProgramItems" select="count($currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist) &gt; 0"/>

		 <xsl:if test="cms:isNotFieldsetEmpty(/view/contentType/fieldset[@role = 'tab' and @name = 'program']) or $hasChildProgramItems">
			<fo:block xsl:use-attribute-sets="fieldset-title">
                <fo:block xsl:use-attribute-sets="fieldset-title-body">
                    <xsl:value-of select="/view/contentType/fieldset[@role = 'tab' and @name = 'program']/label"/>
                </fo:block>
            </fo:block>
            <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab' and @name = 'program']/metadata" mode="display"/>
            
            <xsl:variable name="mode"><xsl:call-template name="table-structure-mode"/></xsl:variable>
            <xsl:choose>
                <xsl:when test="$mode = 'full'">
                    <!-- Mode full (title / type / CM / TD / TP / credits)-->
                    <xsl:apply-templates select="$currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist" mode="program-full"/>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Mode simple (title / credits / total hours) -->
                    <xsl:apply-templates select="$currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist" mode="program"/>
                </xsl:otherwise>
            </xsl:choose>
		</xsl:if>
	</xsl:template>
	
    <xsl:template match="subprogram" mode="program">
        <fo:block xsl:use-attribute-sets="program-subprogram">
            <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:apply-templates select="subprogram|container|courselist" mode="program"/>
    </xsl:template>
    
    <xsl:template match="subprogram" mode="program-full">
        <fo:block xsl:use-attribute-sets="program-subprogram">
            <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:if test="courselist/course">
            <xsl:call-template name="structure-table-header"/>
        </xsl:if>
        <xsl:apply-templates select="subprogram|container|courselist" mode="program-full"/>
    </xsl:template>
    
    <xsl:template match="container[attributes/nature/@code = 'annee']" mode="program">
        <fo:block xsl:use-attribute-sets="program-container-year">
           <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:apply-templates select="container|courselist" mode="program"/>
    </xsl:template>
    
    <xsl:template match="container[attributes/nature/@code = 'annee']" mode="program-full">
        <fo:block xsl:use-attribute-sets="program-container-year">
           <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:if test="courselist/course">
            <xsl:call-template name="structure-table-header"/>
        </xsl:if>
        <xsl:apply-templates select="container|courselist" mode="program-full"/>
    </xsl:template>
    
    <xsl:template match="container[attributes/nature/@code = 'semestre']" mode="program">
        <fo:block xsl:use-attribute-sets="program-container-semester">
           <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:apply-templates select="container|courselist" mode="program"/>
    </xsl:template>
    
    <xsl:template match="container[attributes/nature/@code = 'semestre']" mode="program-full">
        <fo:block xsl:use-attribute-sets="program-container-semester mode-full">
           <xsl:value-of select="@title"/>
        </fo:block>
        
        <xsl:if test="courselist/course">
            <xsl:call-template name="structure-table-header"/>
        </xsl:if>
        <xsl:apply-templates select="container|courselist" mode="program-full"/>
    </xsl:template>
    
    <xsl:template match="container" mode="program">
        <fo:block xsl:use-attribute-sets="program-container">
           <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:apply-templates select="container|courselist" mode="program"/>
    </xsl:template>
    
    <xsl:template match="container" mode="program-full">
        <fo:block xsl:use-attribute-sets="program-container mode-full">
           <xsl:value-of select="@title"/>
        </fo:block>
        <xsl:if test="courselist/course">
            <xsl:call-template name="structure-table-header"/>
        </xsl:if>
        <xsl:apply-templates select="container|courselist" mode="program-full"/>
    </xsl:template>
    
    <xsl:attribute-set name="program-subprogram"/>
    <xsl:attribute-set name="program-container-semester"/>
    <xsl:attribute-set name="program-container-year"/>
    <xsl:attribute-set name="program-container"/>
    <xsl:attribute-set name="program-subprogram"/>
    <!-- // End Program table -->
    
    <!-- // Custom display for partner schools and laboratories-->
    <xsl:template match="metadata[@name='partnerSchools']|metadata[@name='partnerLaboratories']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and ($value/entry/linkUrl or $value/entry/linkLabel)">
            <fo:block page-break-inside="avoid" xsl:use-attribute-sets="partners">
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                
                <xsl:apply-templates select="." mode="value">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerSchools']|metadata[@name = 'partnerLaboratories']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:for-each select="$value/entry">
            <fo:block xsl:use-attribute-sets="partner">
                <xsl:if test="normalize-space(linkLabel) != ''">
                    <fo:block xsl:use-attribute-sets="partner-label">
                        <xsl:value-of select="linkLabel"/>
                    </fo:block>
                </xsl:if>
                <xsl:if test="normalize-space(linkUrl) != ''">
                    <fo:block xsl:use-attribute-sets="partner-link">
                        <xsl:call-template name="link-style"/>
                        <fo:basic-link external-destination="{linkUrl}">
                            <xsl:apply-templates select="$definition" mode="icon"/>
                            <xsl:text>     </xsl:text><xsl:value-of select="linkUrl"/>
                        </fo:basic-link>
                    </fo:block>
                </xsl:if>
            </fo:block>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:attribute-set name="partners"/>
    <xsl:attribute-set name="partner"/>
    <xsl:attribute-set name="partner-label"/>
    <xsl:attribute-set name="partner-link"/>
    
    <xsl:template match="metadata[@name = 'partnerSchools']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf35d;</fo:inline>
    </xsl:template>
    <xsl:template match="metadata[@name = 'partnerLaboratories']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf35d;</fo:inline>
    </xsl:template>
    <!-- // End partner schools and laboratories -->
    
    <!-- // Custom display for program's web sites -->
    <xsl:template match="metadata[@name='programWebSite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and ($value/entry/programWebSiteUrl or $value/entry/programWebSiteLabel)">
            <fo:block page-break-inside="avoid" xsl:use-attribute-sets="websites">
                <fo:block xsl:use-attribute-sets="section-title">
                    <i18n:text i18n:key="PROGRAM_WEB_SITES" i18n:catalogue="skin.{$skin}"/>
                </fo:block>
                
                <xsl:apply-templates select="." mode="value">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programWebSite']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:for-each select="$value/entry">
            <fo:block xsl:use-attribute-sets="website">
                <xsl:if test="normalize-space(programWebSiteLabel) != ''">
                    <fo:block xsl:use-attribute-sets="website-label">
                        <xsl:value-of select="programWebSiteLabel"/>
                    </fo:block>
                </xsl:if>
                <xsl:if test="normalize-space(programWebSiteUrl) != ''">
                    <fo:block xsl:use-attribute-sets="website-link">
                        <xsl:call-template name="link-style"/>
                        <fo:basic-link external-destination="{programWebSiteUrl}">
                            <xsl:apply-templates select="$definition" mode="icon"/>
                            <xsl:text> </xsl:text><xsl:value-of select="programWebSiteUrl"/>
                        </fo:basic-link>
                    </fo:block>
                </xsl:if>
            </fo:block>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:attribute-set name="websites"/>
    <xsl:attribute-set name="website"/>
    <xsl:attribute-set name="website-label"/>
    <xsl:attribute-set name="website-link"/>
    
    <xsl:template match="metadata[@name = 'programWebSite']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf35d;</fo:inline>
    </xsl:template>
    <!-- // End partner schools and laboratories -->
    
    <!-- Further study programs -->
    <xsl:template match="metadata[@name='furtherStudyPrograms']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:block>
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                 <xsl:variable name="definition" select="."/>       
                 <xsl:for-each select="$value">
                    <fo:block xsl:use-attribute-sets="section-body">
                        <xsl:text>• </xsl:text>
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                    </fo:block>
                 </xsl:for-each>
            </fo:block>
        </xsl:if>
    </xsl:template>
    <!-- // End further study programs -->
    
    <xsl:attribute-set name="glyph-icon"/>
    
    <!-- // Undisplayed fieldsets -->
    <xsl:template match="fieldset[@name='key-figures']" mode="display"/>
    <xsl:template match="fieldset[@name='aside']" mode="display"/>
</xsl:stylesheet>
