<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:math="java.lang.Math"
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf docbook math cms exslt">

    <xsl:import href="skin://stylesheets/content/common/zones/aside.xsl"/>
    
    <!-- +
         | Default template to display other links
         + -->
    <xsl:template match="metadata[@name = 'programWebSite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0' and ($value/entry/programWebSiteUrl or $value/entry/programWebSiteLabel)">
            <div class="ametys-sidebar-el ametys-sidebar-el_light">
                <h3 class="ametys-sidebar-title"><i18n:text i18n:key="PROGRAM_WEB_SITES" i18n:catalogue="skin.{$skin}"/></h3>
                
                <div class="ametys-richtext">
                    <ul class="ametys-sidebar-el_list">
                        <xsl:apply-templates select="." mode="value">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </ul>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programWebSite']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:for-each select="$value/entry">
            <li>
                <xsl:choose>
                    <xsl:when test="normalize-space(programWebSiteUrl) != ''">
                        <a href="{programWebSiteUrl}">
                            <xsl:apply-templates select="$definition" mode="website-icon">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                            <xsl:choose>
                               <xsl:when test="normalize-space(programWebSiteLabel) != ''"><xsl:value-of select="programWebSiteLabel"/></xsl:when>
                               <xsl:otherwise><xsl:value-of select="programWebSiteUrl"/></xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="$definition" mode="website-icon">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                        <xsl:value-of select="programWebSiteLabel"/>
                    </xsl:otherwise>
                </xsl:choose>
            </li>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programWebSite']" mode="website-icon">
        <span class="ametys-sidebar-el_list_icon fas fa-up-right-from-square" aria-hidden="true"></span>
    </xsl:template>
    
    <!-- +
         | Default template to display partner schools and partners laboratories
         + -->
    <xsl:template match="metadata[@name = 'partnerSchools']|metadata[@name = 'partnerLaboratories']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0' and ($value/entry/linkUrl or $value/entry/linkLabel)">
            <div class="ametys-sidebar-el ametys-sidebar-el_light">
                <h3 class="ametys-sidebar-title">
                    <xsl:apply-templates select="." mode="title">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </h3>
                
                <div class="ametys-richtext">
                    <ul class="ametys-sidebar-el_list">
                        <xsl:apply-templates select="." mode="value">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </ul>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerSchools']" mode="title">
        <xsl:param name="value"/>
        
        <xsl:choose>
            <xsl:when test="count($value/entry) = 1"><i18n:text i18n:key="PROGRAM_PARTNER_SCHOOL" i18n:catalogue="skin.{$skin}"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:key="PROGRAM_PARTNER_SCHOOLS" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerLaboratories']" mode="title">
        <xsl:param name="value"/>
        
        <xsl:choose>
            <xsl:when test="count($value/entry) = 1"><i18n:text i18n:key="PROGRAM_PARTNER_LABORATORY" i18n:catalogue="skin.{$skin}"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:key="PROGRAM_PARTNER_LABORATORIES" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerSchools']|metadata[@name = 'partnerLaboratories']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:for-each select="$value/entry">
            <li>
                <xsl:choose>
                    <xsl:when test="normalize-space(linkUrl) != ''">
                        <a href="{linkUrl}">
                            <xsl:apply-templates select="$definition" mode="partner-icon">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        
                            <xsl:choose>
                               <xsl:when test="normalize-space(linkLabel) != ''"><xsl:value-of select="linkLabel"/></xsl:when>
                               <xsl:otherwise><xsl:value-of select="linkUrl"/></xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="$definition" mode="partner-icon">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                        <xsl:value-of select="linkLabel"/>
                    </xsl:otherwise>
                </xsl:choose>
            </li>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerLaboratories']" mode="partner-icon">
        <span class="ametys-sidebar-el_list_icon fas fa-flask" aria-hidden="true"></span>
    </xsl:template>
    <xsl:template match="metadata[@name = 'partnerSchools']" mode="partner-icon">
        <span class="ametys-sidebar-el_list_icon fas fa-building-columns" aria-hidden="true"></span>
    </xsl:template>
    
    <!-- +
         | Default template to display joined orgunit
         + -->
    <xsl:template match="metadata[@name = 'jointOrgUnit']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="g-mb-55">
                <h2 class="ametys-section-title"><xsl:value-of select="label"/></h2>
                
                <xsl:variable name="definition" select="."/>
                
                <ul class="ametys-list-with-icon ametys-list-with-icon--blue">
                    <xsl:for-each select="$value">
                        <li class="ametys-list-with-icon__item">
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </li>
                    </xsl:for-each>
                </ul>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'jointOrgUnit']" mode="value">
        <xsl:param name="value"/>
        
        <span class="ametys-list-with-icon__item-icon ametys-icon-building"></span>
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
</xsl:stylesheet>