<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        exclude-result-prefixes="sitemap ametys resolver odf escaper filename url">

    <xsl:import href="skin://stylesheets/content/common/zones/banner.xsl"/>
    
    <xsl:template name="main-banner">
        <xsl:variable name="imgUrl"><xsl:call-template name="main-banner-illustration-url"/></xsl:variable>
        <div class="hero-formation" style="background-image: url({ametys:escapeURLforCSS($imgUrl)});">
            <div class="container">
                <xsl:call-template name="main-banner-label"/>
                <div class="hero-formation__content">
                    <div class="hero-formation__top">
                        <xsl:call-template name="main-banner-category"/>
                        <xsl:call-template name="main-banner-actions"/>
                        <xsl:call-template name="main-banner-title"/>
                    </div>
                    
                    <xsl:call-template name="main-banner-subprograms"/>
                    <xsl:call-template name="main-banner-benefits"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-label">
        <xsl:variable name="label" select="odf:getCertificationLabel(@id)"/>
        
        <xsl:if test="$label != ''">
            <xsl:variable name="labelImgPath" select="concat('templates/common/img/labels/', $label, '.svg')"/>
            <div class="hero-certification">
                <img src="{ametys:skinURL($labelImgPath)}" alt="" data-svg="true"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Template to display a category above the the program's title.
         | By default, display the domain(s) if not empty.
         + -->
    <xsl:template name="main-banner-category">
        <div class="hero-formation__category">
            <xsl:choose>
                <xsl:when test="normalize-space(metadata/domain/@title ) != ''">
                    <xsl:for-each select="metadata/domain">
                        <xsl:value-of select="@title"/><xsl:if test="position() != last()">, </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-title">
        <h1 class="hero-formation__title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <!-- +
         | This template is for banner illustration. The banner is selected in order of priority among :
         | * the illustration of the program if not empty 
         | * or the illustration of the orgunit if not empty
         | * or the banner linked to the domain's code if domain is not empty (see resources/templates/common/img/banners/[CODE].png)
         | * or a default banner of the skin (see resources/templates/common/img/banners/default.png)
         + -->
    <xsl:template name="main-banner-illustration-url">
        <xsl:variable name="orgunitId" select="ametys:contentAttribute(@id, 'orgUnit')/@id"/>
        
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <xsl:call-template name="get-image-uri">
                    <xsl:with-param name="img" select="metadata/illustration/image"/>
                    <xsl:with-param name="height" select="360"/>
                    <xsl:with-param name="width" select="1903"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$orgunitId and ametys:hasValue($orgunitId, 'illustration/image')">
                <xsl:call-template name="get-image-uri-from-attribute">
                    <xsl:with-param name="id" select="$orgunitId"/>
                    <xsl:with-param name="height" select="360"/>
                    <xsl:with-param name="width" select="1903"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="metadata/domain">
                <xsl:variable name="code" select="ametys:contentAttribute(metadata/domain/@id, 'code')"/>
                <xsl:variable name="domainImgPath" select="concat('templates/common/img/banners/', $code, '.png')"/>
                <xsl:choose>
                    <xsl:when test="ametys:skinResources($domainImgPath)">
                        <xsl:value-of select="ametys:skinURL($domainImgPath)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="main-banner-illustration-default-url"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:call-template name="main-banner-illustration-default-url"/></xsl:otherwise><!-- default image -->
        </xsl:choose>
    </xsl:template>
    
    <!-- +
         | Template to display the available subprograms
         + -->
    <xsl:template name="main-banner-subprograms">
        <xsl:variable name="structure" select="odf:getProgramStructure(@id, 1)"/>
        <xsl:variable name="count" select="count($structure/subprogram)"/>
        <xsl:variable name="programId" select="@id"/>
        
        <xsl:if test="$count &gt; 0">
            <div class="btn-parcours-group">
                <button class="btn btn-primary btn-parcours" aria-expanded="false">
                    <xsl:choose>
                        <xsl:when test="$count = 1">
                            <i18n:text i18n:key="PROGRAM_HEADER_AVAILABLE_SUBPROGRAM" i18n:catalogue="skin.{$skin}"/>        
                        </xsl:when>
                        <xsl:otherwise>
                            <i18n:translate>
                                <i18n:text i18n:key="PROGRAM_HEADER_AVAILABLE_SUBPROGRAMS" i18n:catalogue="skin.{$skin}"/>
                                <i18n:param><xsl:value-of select="$count"/></i18n:param>
                            </i18n:translate>
                        </xsl:otherwise>
                    </xsl:choose>
                </button>
                <div class="btn-parcours-dropdown" aria-hidden="true">
                    <ul>
                        <xsl:for-each select="$structure/subprogram">
                            <li>
                                <a href="{resolver:resolve('odf', concat(@id, ';', $programId))}">
                                    <xsl:value-of select="@title"/>
                                </a>
                            </li>
                        </xsl:for-each>
                    </ul>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>