<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:math="java.lang.Math" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:str="http://exslt.org/strings"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:exslt="http://exslt.org/common"
    exclude-result-prefixes="xalan math str ametys resolver stringutils">  
    
    <xsl:decimal-format decimal-separator="," grouping-separator=" "/>
    
    <!-- +
         | Helper for program's illustration. The illustration is selected in order of priority among :
         | * the illustration of the program if not empty 
         | * or the illustration of the orgunit if not empty
         | * or the banner linked to the domain's code if domain is not empty (see resources/templates/common/img/[width]x[height]/[code].png)
         | * or a default banner of the skin (see resources/templates/common/img/[width]x[height/default.png)
         + -->
    <xsl:template name="program-image-url">
        <xsl:param name="contentId" select="@id"/>
        <xsl:param name="maxWidth" select="'400'"/>
        <xsl:param name="maxHeight" select="'270'"/>
        <xsl:param name="type" select="'cropped'"/>
        <xsl:param name="skinDirPrefix" select="concat('templates/common/img/', $maxWidth, 'x', $maxHeight, '/')"/>
        
        <xsl:variable name="orgunitId" select="ametys:contentAttribute($contentId, 'orgUnit')/@id"/>
        
        <xsl:variable name="imgUri">
            <xsl:choose>
                <xsl:when test="ametys:hasValue($contentId, 'illustration/image')">
                    <xsl:call-template name="get-image-uri-from-attribute">
                        <xsl:with-param name="id" select="$contentId"/>
                        <xsl:with-param name="height" select="$maxHeight"/>
                        <xsl:with-param name="width" select="$maxWidth"/>
                        <xsl:with-param name="isCropped" select="$type = 'cropped'"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$orgunitId and ametys:hasValue($orgunitId, 'illustration/image')">
                    <xsl:call-template name="get-image-uri-from-attribute">
                        <xsl:with-param name="id" select="$orgunitId"/>
                        <xsl:with-param name="height" select="$maxHeight"/>
                        <xsl:with-param name="width" select="$maxWidth"/>
                        <xsl:with-param name="isCropped" select="$type = 'cropped'"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$orgunitId and ametys:hasValue($orgunitId, 'logo/image')">
                    <xsl:call-template name="get-image-uri-from-attribute">
                        <xsl:with-param name="id" select="$orgunitId"/>
                        <xsl:with-param name="attributePath" select="'logo/image'"/>
                        <xsl:with-param name="height" select="$maxHeight"/>
                        <xsl:with-param name="width" select="$maxWidth"/>
                        <xsl:with-param name="isCropped" select="$type = 'cropped'"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$imgUri != ''"><xsl:value-of select="$imgUri"/></xsl:when>
            <xsl:when test="ametys:hasValue($contentId, 'domain')">
                <!-- illustration of domain (into skin directory) -->
                <xsl:variable name="domainId" select="ametys:contentAttribute($contentId, 'domain')/@id"/>
                <xsl:variable name="code" select="ametys:contentAttribute($domainId, 'code')"/>
                <xsl:variable name="domainImgPath" select="concat($skinDirPrefix, $code, '.png')"/>
                <xsl:choose>
                    <xsl:when test="ametys:skinResources($domainImgPath)">
                        <xsl:value-of select="ametys:skinURL($domainImgPath)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- default image -->
                        <xsl:call-template name="program-default-image-url">
                            <xsl:with-param name="skinDirPrefix" select="$skinDirPrefix"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- default image -->
                <xsl:call-template name="program-default-image-url">
                    <xsl:with-param name="skinDirPrefix" select="$skinDirPrefix"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="program-default-image-url">
        <xsl:param name="skinDirPrefix"/>
        
        <xsl:value-of select="ametys:skinURL(concat($skinDirPrefix, 'default.png'))"/>
    </xsl:template>
    
    <!-- +
         | Helper to transform a double value :
         | point is replaced by coma, and value sush as "4.0" is transformed to 4.
         +  -->
    <xsl:template name="transform-double">
        <xsl:param name="value"/>
        
        <xsl:value-of select='format-number($value, "#,##")' />
    </xsl:template>
    
    <xsl:template name="content-geocode-marker">
        <xsl:param name="data"/>
        
        <xsl:variable name="rawMarkers">
            <markers>
                <xsl:choose>
                    <xsl:when test="$data/geoCode">
                        <marker title="{concat($data/geoCode/@latitude, '°N, ', $data/geoCode/@longitude, '°E')}" holder="geoCode" lat="{$data/geoCode/@latitude}" lng="{$data/geoCode/@longitude}"/>
                    </xsl:when>
                    
                    <xsl:otherwise>
                        <xsl:for-each select="$data/campus">
                            <xsl:variable name="geocode" select="ametys:contentAttribute(@id, 'geocode')"/>
                            <xsl:if test="$geocode">
                                <marker title="{@title}" holder="{local-name()}" lat="{$geocode/@latitude}" lng="{$geocode/@longitude}"/>
                            </xsl:if>
                        </xsl:for-each>
                        <xsl:for-each select="$data/place">
                            <xsl:variable name="geocode" select="ametys:contentAttribute(@id, 'geocode')"/>
                            <xsl:if test="$geocode">
                                <marker title="{@title}" holder="{local-name()}" lat="{$geocode/@latitude}" lng="{$geocode/@longitude}"/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </markers>
        </xsl:variable>
        
        <xsl:variable name="allMarkers" select="exslt:node-set($rawMarkers)"/>
        
        <xsl:if test="$allMarkers/markers/marker">
            <markers>
                <xsl:choose>
                   <xsl:when test="$allMarkers/markers/marker[@holder = 'geoCode']">
                        <xsl:copy-of select="$allMarkers/markers/marker[@holder = 'geoCode']"/>
                   </xsl:when>
                   <xsl:when test="$allMarkers/markers/marker[@holder = 'campus']">
                        <xsl:copy-of select="$allMarkers/markers/marker[@holder = 'campus']"/>
                   </xsl:when>
                   <xsl:when test="$allMarkers/markers/marker[@holder = 'place']">
                        <xsl:copy-of select="$allMarkers/markers/marker[@holder = 'place']"/>
                   </xsl:when>
                </xsl:choose>     
            </markers>
        </xsl:if>
    </xsl:template>
    
    <!-- Helper to get URI of an image attribute -->
    <xsl:template name="get-image-uri-from-attribute">
        <xsl:param name="id"/>
        <xsl:param name="attributePath" select="'illustration/image'"/>
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="isCropped" select="false()"/>
        
        <xsl:if test="ametys:hasValue($id, $attributePath)">
            <xsl:call-template name="get-image-uri">
                <xsl:with-param name="img" select="ametys:contentAttribute($id, $attributePath)"/>
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
                <xsl:with-param name="isCropped" select="$isCropped"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="get-image-uri">
        <xsl:param name="img"/>
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="isCropped" select="false()"/>
        
        <xsl:choose>
            <xsl:when test="$isCropped"><xsl:value-of select="resolver:resolveCroppedImage($img/@type, $img/@uri, $height, $width)" /></xsl:when>
            <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($img/@type, $img/@uri, $height, $width)" /></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>