<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:exsl="http://exslt.org/common"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="exsl str">
                
                
    <!-- FONT PDF IMPORTED : WEB-INF/param/fop-user-config.xml -->
    
    <!-- // Color variables -->
    <xsl:variable name="primary-color">#521C7E</xsl:variable>
    <xsl:variable name="primary-color-light">#e3c6f3</xsl:variable>
    <xsl:variable name="primary-color-light-2">#f9f1fe</xsl:variable>
    <xsl:variable name="text-color">#000</xsl:variable>
    <xsl:variable name="gray-color">#4d565b</xsl:variable>
    <xsl:variable name="gray-color-light">#bfc9ca</xsl:variable>
    <xsl:variable name="gray-color-light-2">#91999d</xsl:variable>
    <xsl:variable name="gray-color-light-3">#f5f5f5</xsl:variable>
    <!-- // End Color variables -->
    
    <!-- // Default font -->
    <xsl:variable name="default-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: Roboto, sans-serif;
    font-style: normal;
    font-weight: 300;
    font-size: 11px;
    line-height:1.5;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="default-font-size" select="substring-before(exsl:node-set($default-font)/font-size, 'px')"/>
    
    <!-- // Common properties for headings -->
    <xsl:variable name="heading-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: Roboto, sans-serif;
    font-style: normal;
    font-weight: 400;
    font-size: 14px;
    line-height: 1.5;
    text-decoration: none;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <!-- // Common properties for links -->
    <xsl:variable name="link-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">color:<xsl:value-of select="$primary-color"/></xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:attribute-set name="glyph-icon">
        <xsl:attribute name="color"><xsl:value-of select="$gray-color-light-2"/></xsl:attribute>
    </xsl:attribute-set>
    
    
    <!-- cst = dpi/2.54 -->
    <!-- mm * cst = px -->
    <xsl:variable name="TheConstantMilli">2.834</xsl:variable>
    
    <xsl:template name="deserialize">
        <xsl:param name="css"/>
        <xsl:for-each select="str:tokenize($css, ';&#x9;&#xA;&#xD;')">
            <xsl:variable name="value" select="normalize-space(substring-after(., ':'))"/>
            <xsl:element name="{normalize-space(substring-before(., ':'))}">
                <xsl:if test="substring($value, string-length($value) - 1) = 'px'">
                    <xsl:attribute name="mm">
                        <xsl:call-template name="px-to-mm">
                            <xsl:with-param name="px" select="substring-before($value, 'px')"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:if>
                <xsl:value-of select="$value"/>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="px-to-mm">
        <xsl:param name="px"/>
        <xsl:value-of select="round($px div $TheConstantMilli)"/>
        <xsl:text>mm</xsl:text>
    </xsl:template>
    
    <!-- // Header -->
    <xsl:attribute-set name="header">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="background-color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="color">#FFFFFF</xsl:attribute>
        <xsl:attribute name="padding-bottom">5mm</xsl:attribute>
        <xsl:attribute name="padding-top">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="header-category">
        <xsl:attribute name="margin-left">5mm</xsl:attribute>
        <xsl:attribute name="margin-bottom">2mm</xsl:attribute>
        <xsl:attribute name="font-size">9px</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="header-title">
        <xsl:attribute name="margin-left">5mm</xsl:attribute>
        <xsl:attribute name="font-size">20px</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="header-subtitle">
        <xsl:attribute name="margin-left">5mm</xsl:attribute>
        <xsl:attribute name="font-size">10px</xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Header -->
    
    <!-- // Benefits -->
    <xsl:attribute-set name="benefits-block">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="margin-bottom">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="benefits-icon">
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="benefits-header">
        <xsl:attribute name="font-weight">400</xsl:attribute>
        <xsl:attribute name="font-size">10px</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="benefits-value">
        <xsl:attribute name="font-size">10px</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Benefits -->
    
    <!-- // Fieldset -->
    <xsl:attribute-set name="fieldset-title">
    </xsl:attribute-set>
    <xsl:attribute-set name="fieldset-title-body">
        <xsl:attribute name="margin-bottom">5mm</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-size">22px</xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Fieldset -->
    
    <!-- // Richtext -->
    <xsl:attribute-set name="section-title">
        <xsl:attribute name="font-size">16px</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="border-top-color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="border-top-style">solid</xsl:attribute>
        <xsl:attribute name="border-top-width">.1mm</xsl:attribute>
        <xsl:attribute name="padding-top">2mm</xsl:attribute>
        <xsl:attribute name="space-after">4mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="section-body">
        <xsl:attribute name="margin-bottom">5mm</xsl:attribute>
    </xsl:attribute-set>
    <!-- // End richtext -->
    
    <!-- +
         | 
         + -->
    <xsl:template name="main-body-block">
        <xsl:for-each select="exsl:node-set($default-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
        <xsl:attribute name="color"><xsl:value-of select="$text-color"/></xsl:attribute>
        <xsl:attribute name="space-before">1cm</xsl:attribute>
        <xsl:attribute name="margin-top">0cm</xsl:attribute>
        <xsl:attribute name="margin-left">0cm</xsl:attribute>
        <xsl:attribute name="margin-right">0cm</xsl:attribute>
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="line-height">1.5</xsl:attribute>
    </xsl:template>
    
    <!-- // Subprogram list -->
    <xsl:attribute-set name="subprogram-block">
        <xsl:attribute name="background-color"><xsl:value-of select="$primary-color-light-2"/></xsl:attribute>
        <xsl:attribute name="border-color"><xsl:value-of select="$primary-color-light"/></xsl:attribute>
        <xsl:attribute name="border-width">small</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="space-after">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="subprogram-block-body">
        <xsl:attribute name="margin">0mm</xsl:attribute>
        <xsl:attribute name="padding">4mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="subprogram-block-title">
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-size">14px</xsl:attribute>
        <xsl:attribute name="space-after">2mm</xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Subprogram list -->
    
     <!-- // Key infos -->
    <xsl:attribute-set name="key-info-block">
        <xsl:attribute name="background-color"><xsl:value-of select="$primary-color-light-2"/></xsl:attribute>
        <xsl:attribute name="border-color"><xsl:value-of select="$primary-color-light"/></xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="space-after">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="key-info-block-body">
        <xsl:attribute name="margin">0mm</xsl:attribute>
        <xsl:attribute name="padding">4mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="key-info-block-title">
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-size">14px</xsl:attribute>
        <xsl:attribute name="space-after">2mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="key-info-block-content">
        <xsl:attribute name="space-after">1mm</xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Key infos -->
    
    <!-- // Contacts -->
    <xsl:attribute-set name="contact">
        <xsl:attribute name="space-after">4mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="contact-role">
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-weight">400</xsl:attribute>
        <xsl:attribute name="font-size">11px</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="contact-title">
        <xsl:attribute name="font-size">11px</xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Contacts -->
    
    <xsl:attribute-set name="location">
        <xsl:attribute name="font-size">11px</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="partners"/>
    <xsl:attribute-set name="partner">
        <xsl:attribute name="space-after">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="partner-label">
        <xsl:attribute name="font-size">11px</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="partner-link"/>
    <xsl:attribute-set name="websites"/>
    <xsl:attribute-set name="website">
        <xsl:attribute name="space-after">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="website-label">
        <xsl:attribute name="font-size">11px</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="website-link"/>
    
    
    <!-- // Program table -->
    <xsl:attribute-set name="program-subprogram">
        <xsl:attribute name="font-size">14px</xsl:attribute>
        <xsl:attribute name="space-before">10mm</xsl:attribute>
        <xsl:attribute name="space-after">2mm</xsl:attribute>
        <xsl:attribute name="font-weight">400</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="program-container">
        <xsl:attribute name="font-size">11px</xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-width">.1mm</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
        <xsl:attribute name="space-before">5mm</xsl:attribute>
        <xsl:attribute name="space-after">2mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="program-container-year">
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-size">13px</xsl:attribute>
        <xsl:attribute name="space-before">5mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="program-container-semester">
        <xsl:attribute name="font-size">12px</xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-width">.1mm</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
        <xsl:attribute name="space-before">5mm</xsl:attribute>
        <xsl:attribute name="space-after">2mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="mode-full">
        <xsl:attribute name="border-bottom-width">0mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="program-subprogram"/>
    <xsl:attribute-set name="course-table">
        <xsl:attribute name="space-after">2mm</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="course-title"/>
    <xsl:attribute-set name="course-ects">
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="course-hours">
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="course-nature">
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="course-level1">
        <xsl:attribute name="font-weight">400</xsl:attribute>
        <xsl:attribute name="padding-top">3pt</xsl:attribute>
        <xsl:attribute name="padding-bottom">3pt</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="structure-table-header">
        <xsl:attribute name="font-weight">500</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-width">thin</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
    </xsl:attribute-set>
    <!-- // End Program table -->
    
    <!-- // Footer -->
    <xsl:template name="footer-copyright-style">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-weight">300</xsl:attribute>
        <xsl:attribute name="font-style">normal</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
    </xsl:template>
    <xsl:template name="footer-text-style">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-weight">300</xsl:attribute>
        <xsl:attribute name="font-style">normal</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
    </xsl:template>
    <xsl:template name="footer-pages-style">
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="width">3cm</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-style">normal</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
    </xsl:template>
    <!-- // End Footer -->
    
    <xsl:template name="xsl-region-before">
        <fo:static-content flow-name="xsl-region-before">
              <fo:block-container absolute-position="fixed" left="0in" top="0in" width="21cm" height="29.7cm">
                  <fo:block />
              </fo:block-container>
        </fo:static-content>
    </xsl:template>
    
    <!-- // Paragraph -->
    <xsl:template name="para-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="space-before">0mm</xsl:attribute>
        <xsl:attribute name="space-after">4mm</xsl:attribute>
        <xsl:attribute name="font-weight">300</xsl:attribute>
        <xsl:attribute name="text-align">justify</xsl:attribute>
        
        <xsl:choose>
            <xsl:when test="$class = 'important'">
                <xsl:attribute name="background-color"><xsl:value-of select="$primary-color-light-2"/></xsl:attribute>
                <xsl:attribute name="padding">5mm</xsl:attribute>
                <xsl:attribute name="margin">0mm</xsl:attribute>
            </xsl:when>
            <xsl:when test="$class = 'introduction'">
                <xsl:attribute name="font-size"><xsl:value-of select="round(1.1 * $default-font-size)"/>px</xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!-- // End Paragraph -->
    
    <!-- // Link -->
    <xsl:template name="link-style">
        <xsl:for-each select="exsl:node-set($link-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Overriden from docbook2fo.xsl to add font glyph -->
    <xsl:template name="link-href-style">
        <fo:inline font-family="FontAwesome" font-weight="bold">&#xf35d;</fo:inline><xsl:text> </xsl:text>
    </xsl:template>
    
    <!-- // Images -->
    <xsl:template name="image-style">
    </xsl:template>
    
    <!-- // Heading -->
    <xsl:template name="title-style">
        <xsl:param name="level"/>
        
        <!-- Common attributes -->
        <xsl:for-each select="exsl:node-set($heading-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
        
        <xsl:choose>
            <xsl:when test="$level = '1'">
                <xsl:attribute name="space-before">2mm</xsl:attribute>
                <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
            </xsl:when>
            <xsl:when test="$level = '2'">
                <xsl:attribute name="font-size">12px</xsl:attribute>
                <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!-- // End Heading -->
    
    <!-- Tables -->
    <xsl:template name="table-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="border-collapse">collapse</xsl:attribute>
        <xsl:attribute name="space-after">10mm</xsl:attribute>
        <xsl:choose>
            <xsl:when test="$class = 'invisible'">
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="border-color"><xsl:value-of select="$gray-color"/></xsl:attribute>
                <xsl:attribute name="border-style">solid</xsl:attribute>
                <xsl:attribute name="border-width">medium</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="th-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="padding">1mm 1mm 1mm 1mm</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:choose>
            <xsl:when test="contains($class,'invisible')">
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="border-color"><xsl:value-of select="$gray-color"/></xsl:attribute>
                <xsl:attribute name="border-style">solid</xsl:attribute>
                <xsl:attribute name="border-width">small</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="td-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="padding">1mm 1mm 1mm 1mm</xsl:attribute>
        <xsl:attribute name="margin">0</xsl:attribute>
        <xsl:choose>
            <xsl:when test="contains($class,'invisible')">
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="border-color"><xsl:value-of select="$gray-color"/></xsl:attribute>
                <xsl:attribute name="border-style">solid</xsl:attribute>
                <xsl:attribute name="border-width">small</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- End Tables -->
    
    <!-- MCC Table -->
    <xsl:template name="mcc-table-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="border-collapse">collapse</xsl:attribute>
        <xsl:attribute name="space-after">10mm</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="mcc-th-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="padding">1mm 1mm 1mm 1mm</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-width">thin</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="mcc-td-style">
        <xsl:param name="class"/>
        <xsl:param name="border-style">dashed</xsl:param>
        
        <xsl:attribute name="padding">2mm 1mm 2mm 1mm</xsl:attribute>
        <xsl:attribute name="margin">0</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
        <xsl:attribute name="border-bottom-style"><xsl:value-of select="$border-style"/></xsl:attribute>
        <xsl:attribute name="border-bottom-width">thin</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="mcc-td-educational-path-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="padding">3mm 1mm 0mm 1mm</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="margin">0</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="font-style">italic</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
        <xsl:attribute name="font-size">9px</xsl:attribute>
    </xsl:template>
    <!-- End MCC Table -->
    
    <!-- Skills Table -->
    <xsl:template name="skills-table-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="border-collapse">collapse</xsl:attribute>
        <xsl:attribute name="space-after">10mm</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="skills-th-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="padding">1mm 1mm 1mm 1mm</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-width">thin</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="skills-td-style">
        <xsl:param name="class"/>
        
        <xsl:attribute name="padding">2mm 1mm 2mm 1mm</xsl:attribute>
        <xsl:attribute name="margin">0</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="border-bottom-color"><xsl:value-of select="$gray-color-light"/></xsl:attribute>
        <xsl:attribute name="border-bottom-style">dashed</xsl:attribute>
        <xsl:attribute name="border-bottom-width">thin</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
        <xsl:attribute name="display-align">center</xsl:attribute>
    </xsl:template>
    <!-- End Skills Table -->
    
    <!-- TOC Catalog -->
    <xsl:attribute-set name="catalog-toc-title">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="catalog-toc-degree">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-size">12px</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="margin-top">5mm</xsl:attribute>
        <xsl:attribute name="margin-left">5mm</xsl:attribute>
        <xsl:attribute name="margin-right">10mm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="catalog-toc-program">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-size">11px</xsl:attribute>
        <xsl:attribute name="margin-top">2mm</xsl:attribute>
        <xsl:attribute name="margin-left">10mm</xsl:attribute>
        <xsl:attribute name="margin-right">10mm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="catalog-toc-subprogram">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-size">10px</xsl:attribute>
        <xsl:attribute name="margin-top">2mm</xsl:attribute>
        <xsl:attribute name="margin-left">15mm</xsl:attribute>
        <xsl:attribute name="margin-right">10mm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="catalog-toc-program-link">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-size">11px</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$text-color"/></xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="catalog-toc-subprogram-link">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="font-size">10px</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$text-color"/></xsl:attribute>
    </xsl:attribute-set>
    
    <!-- End TOC Catalog -->
    
    <!-- Catalog Front Page -->
    <xsl:attribute-set name="front-page-styles">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-size">26px</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="front-page-catalog-title">
        <xsl:attribute name="margin-top">1cm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="front-page-catalog-subtitle">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="font-size">22px</xsl:attribute>
        <xsl:attribute name="margin-top">0.5cm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="front-page-catalog-subtitle">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="font-size">20px</xsl:attribute>
        <xsl:attribute name="margin-top">0.5cm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="front-page-catalog-orgunit">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$primary-color"/></xsl:attribute>
        <xsl:attribute name="font-size">16px</xsl:attribute>
        <xsl:attribute name="margin-top">1cm</xsl:attribute>
    </xsl:attribute-set>
    
    <xsl:attribute-set name="front-page-catalog-degree">
        <xsl:attribute name="font-family">Roboto, sans-serif</xsl:attribute>
        <xsl:attribute name="color"><xsl:value-of select="$gray-color"/></xsl:attribute>
        <xsl:attribute name="font-size">16px</xsl:attribute>
        <xsl:attribute name="margin-top">1cm</xsl:attribute>
    </xsl:attribute-set>
    <!-- End Catalog Front Page -->
    
</xsl:stylesheet>
