<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
    
    <xsl:import href="wa://tracking" />
    
	<!-- + | HEAD + -->
	<xsl:template name="head">
		<head>
            
            <xsl:call-template name="head-meta-top"/>        
            <title><xsl:call-template name="get-title" /></title>
            
            <xsl:call-template name="meta" />
            <xsl:call-template name="og-meta" />
                
			<xsl:call-template name="common-css"/>
            <xsl:call-template name="additionnal-css" />
            
            <xsl:call-template name="common-script"/>
            <xsl:call-template name="additionnal-script" />
            
            <xsl:call-template name="web-tracking"/>
            
            <xsl:call-template name="head-other"/>
		</head>
	</xsl:template>
    
    <xsl:template name="head-meta-top">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, maximum-scale=1, user-scalable=0"/>
    </xsl:template>
    
    <xsl:template name="get-title">
        <xsl:choose>
            <xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
            <xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
        </xsl:choose>
        <i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <!-- + 
         | META
         + -->
    <xsl:template name="meta">
        <meta content="Ametys CMS Open source (http://www.ametys.org)" name="generator"/>
        
        <meta name="author" content="Ametys V4" />
        <meta name="copyright" content="Ametys V4" />
        <meta name="language" content="{$lang}" />
        <meta name="revisit-after" content="15 days" />
        
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.subject']">
            <meta name="subject" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.subject']/@content}"/>
        </xsl:if>
        
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.description']">
            <meta name="description" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.description']/@content}"/>
        </xsl:if>
        
        <!-- Copy Dublin Core metadata. -->
        <xsl:copy-of select="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[starts-with(@name, 'DC.')]"/>
    </xsl:template>
    
    <!-- + 
         | OPEN GRAPH META
         + -->
    <xsl:template name="og-meta">
        <xsl:comment>
            <xsl:for-each select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type = 'CONTENT'][1]/html/head">
                    <meta property="og:title" content="{meta[@name = 'DC.title']/@content}" />
                    <xsl:if test="meta[@name = 'DC.description']">
                        <meta property="og:description" content="{meta[@name = 'DC.description']/@content}" />
                    </xsl:if>
                    <xsl:if test="meta[@name = 'DC.type']">
                        <meta property="og:type" content="{meta[@name = 'DC.type']/@content}" />
                    </xsl:if>
            </xsl:for-each>
        </xsl:comment>
    </xsl:template>

    <xsl:template name="head-css-jquery">
        <link rel="stylesheet" href="{ametys:pluginResourceURL('jquery-ui', 'css/ui-lightness/jquery-ui.css')}" />
    </xsl:template>
    
	<xsl:template name="common-css">
         <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
         
         <xsl:call-template name="custom-css"/>
	</xsl:template>
    
    <!-- Custom css (ex: additional fonts )-->
    <xsl:template name="custom-css"/>
	
    <xsl:template name="common-script">
        <script type="text/javascript" src="{ametys:skinURL('components/header/header.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('components/footer/footer.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/svgconvert.js')}"></script>
        <xsl:call-template name="custom-script"/>
    </xsl:template>
    
    <xsl:template name="favico">
        <xsl:choose>
            <xsl:when test="ametys:skinResources('templates/common/img/favicon/favicon.ico')">
                <link rel="icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
                <link rel="shortcut icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
            </xsl:when>
            <xsl:otherwise>
                <link rel="icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
            </xsl:otherwise>
        </xsl:choose>
        <meta name="msapplication-config" content="{ametys:skinURL('templates/common/img/favicon/browserconfig.xml')}" /> 
        <meta name="theme-color" content="#ffffff" /> 
    </xsl:template>
	
    <xsl:template name="additionnal-css"/>
    
    <xsl:template name="additionnal-script"/>
    
    <!-- Custom script -->
    <xsl:template name="custom-script"/>
    
    <!-- Other instructions for head -->
    <xsl:template name="head-other"/>
</xsl:stylesheet>
