<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:html="http://www.w3.org/1999/xhtml"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:forms="org.ametys.plugins.forms.xslt.FormsXSLTHelper"
				xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="docbook xlink resolver ametys">
                
    
    <xsl:import href="plugin:web://stylesheets/io/docbook2html.xsl"/>
    
    <!-- Remove pirobox (use fancybox) and add image-container-->
    <xsl:template name="image-wrapper">
      <xsl:variable name="src-full" select="resolver:resolve(docbook:imagedata/@type, docbook:imagedata/@fileref)"/>

      <span class="image-wrapper {../@class}">
			<span class="image-container">
                <xsl:choose>
                    <xsl:when test="../@zoomable and not($src-full = '') and not(ancestor::docbook:link)">
                        <a href="{$src-full}" class="js-fancybox" data-fancybox="lightbox-gallery-{$uniqueId}" rel="single" title="{../docbook:caption}" data-overlay-bg="rgba(0, 0, 0, 1)">
                            <xsl:call-template name="image-wrapper-link-attributes"/>
                            <xsl:call-template name="image" />
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="image" />
                    </xsl:otherwise>
                </xsl:choose>          
            </span>
            <xsl:if test="../docbook:caption">
                <br style="clear: both" />
                <span class="legend">
                    <xsl:variable name="width"><xsl:value-of select="substring-before(docbook:imagedata/@width, 'px')" /></xsl:variable>
                    <xsl:attribute name="style">display: inline-block;<xsl:if test="$width != ''"> width: <xsl:value-of select="$width"/>px;</xsl:if></xsl:attribute>
                    
                    <xsl:value-of select="../docbook:caption" />
                </span>
            </xsl:if>
        </span>
    </xsl:template>
    
</xsl:stylesheet>
