<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">

    <xsl:import href="skin://stylesheets/variables.xsl" />
    <xsl:import href="skin://stylesheets/head.xsl" />
    <xsl:import href="skin://stylesheets/header.xsl"/>
    <xsl:import href="skin://stylesheets/footer.xsl"/>

	<!-- + | BASE + -->
	<xsl:template name="template">
		<html>
			<xsl:call-template name="head" />
            <xsl:call-template name="body" />
		</html>
	</xsl:template>
    
    <xsl:template name="body">
        <body>
            <xsl:call-template name="accessibility-links"/>
            
            <xsl:call-template name="top-search-form-mobile"/>
            
            <xsl:call-template name="header"/>
            
            <main role="main" id="main-content">
                <xsl:call-template name="main-content"/>
            </main>
            
            <xsl:call-template name="footer"/>
            
            <xsl:call-template name="back-to-top"/>
        </body>
    </xsl:template>
    
    <xsl:template name="accessibility-links">
        <div class="accessibility">
            <a class="skip-link" href="#main-content"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_CONTENT" i18n:catalogue="skin.{$skin}"/></a>
            <a class="skip-link" href="#main-menu"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_NAVIGATION" i18n:catalogue="skin.{$skin}"/></a>
            <xsl:if test="$template != 'login' and $template != 'signup'">
                <a  class="skip-link" href="#search"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_SEARCH" i18n:catalogue="skin.{$skin}"/></a>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-form-mobile">
        <div class="overlay-search"/>
        <form class="search__form__fixed" role="search" action="{$mainSearchPageUri}" aria-label="skin.{$skin}:SKIN_SEARCH_FORM_LABEL" i18n:attr="aria-label"  method="POST" id="search">
            <label class="sr-only" for="site-search"><i18n:text i18n:key="SKIN_SEARCH_INPUT_LABEL" i18n:catalogue="skin.{$skin}"/></label>
            <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                <path d="M5.0603 0C7.85491 0.000134 10.1199 2.2659 10.1199 5.06055C10.1198 6.19707 9.74565 7.24613 9.11304 8.09082L10.1326 9.11035C10.6138 8.98063 11.1484 9.10372 11.5291 9.48438L13.5759 11.5312C14.1397 12.0954 14.1434 13.0068 13.575 13.5752C13.0104 14.1397 12.0991 14.1439 11.531 13.5762L9.48413 11.5293C9.10536 11.1505 8.97989 10.6148 9.11011 10.1318L8.09058 9.11328C7.24588 9.7459 6.19682 10.1201 5.0603 10.1201C2.26566 10.1201 -0.000110138 7.85516 -0.000244141 5.06055C-0.000244141 2.26582 2.26558 0 5.0603 0ZM5.0603 1.44531C3.06415 1.44531 1.44618 3.06345 1.44604 5.05957C1.44604 7.0558 3.06407 8.67383 5.0603 8.67383C7.05642 8.67369 8.67456 7.05572 8.67456 5.05957C8.67443 3.06353 7.05634 1.44545 5.0603 1.44531Z" fill="white"></path>
            </svg>
            
            <input class="search__form__fixed__input" id="site-search" name="{$searchInputName}" type="search" placeholder="skin.{$skin}:SKIN_SEARCH_INPUT_PLACEHOLDER" i18n:attr="placeholder" enterkeyhint="search" autocomplete="search" spellcheck="false"/>
            <button class="search__btn" type="submit"><i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/></button>
        </form>
    </xsl:template>
    
    <xsl:template name="back-to-top">
        <button class="up-page" onclick="upPage()" aria-label="skin.{$skin}:SKIN_BACK_TO_TOP" i18n:attr="aria-label">
            <svg width="13" height="15" viewBox="0 0 13 15" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                <path d="M12.1109 6.86353C11.9234 7.05103 11.6734 7.14478 11.4234 7.14478C11.1422 7.14478 10.8922 7.05103 10.7047 6.86353L7.42344 3.58228V13.1448C7.42344 13.7073 6.95469 14.1448 6.42344 14.1448C5.92344 14.1448 5.42344 13.7073 5.42344 13.1448V3.58228L2.11094 6.86353C1.73594 7.26978 1.07969 7.26978 0.704688 6.86353C0.298438 6.48853 0.298438 5.83228 0.704688 5.45728L5.70469 0.457275C6.07969 0.0510254 6.73594 0.0510254 7.11094 0.457275L12.1109 5.45728C12.5172 5.83228 12.5172 6.48853 12.1109 6.86353Z" fill="#521C7E"></path>
            </svg>
        </button>
    </xsl:template>
    
    <!-- + 
         | BREAD CRUMB
         + -->
    <xsl:template name="breadcrumb">
        <nav id="breadcrumb" class="breadcrumb" role="navigation" aria-label="skin.{$skin}:SKIN_BREADCRUMB_ARIA_LABEL" i18n:attr="aria-label">
            <div class="container">
                <ul>
                    <xsl:if test="/cms/inputData/sitemap/page[@sitemap:name = 'index']">
                        <li>
                            <a href="{$site-uri-prefix}/{$lang}/index.html">
                                <xsl:value-of select="/cms/inputData/sitemap/page[@sitemap:name = 'index']/@sitemap:title"/>
                            </a>
                        </li>
                    </xsl:if>
                    
                    <xsl:apply-templates select="/cms/inputData/sitemap/page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']|/cms/inputData/sitemap/page[@sitemap:path = 'index']/page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
                </ul>
            </div>
        </nav>
    </xsl:template>
    
    <xsl:template match="page" mode="breadcrumb">
        <li>
            <xsl:choose>
                <xsl:when test="not(@sitemap:current)">
                    <a href="{resolver:resolve('page', @sitemap:id)}">
                       <xsl:value-of select="@sitemap:title" />
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="aria-current">page</xsl:attribute>
                        <xsl:value-of select="@sitemap:long-title" />
                </xsl:otherwise>
            </xsl:choose>
        </li>
        
        <xsl:apply-templates select="page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
    </xsl:template>
</xsl:stylesheet>
