/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class RepeaterDistributionValidator
extends AbstractContentValidator
implements Configurable,
Serviceable {
    private String _repeaterPath;
    private String _percentagePath;
    private List<String> _attributePath;
    private RepeaterDefinition _repeaterDef;
    private I18nUtils _i18nUtils;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._repeaterPath = configuration.getChild("repeater").getAttribute("path");
        this._percentagePath = configuration.getChild("percentage", true).getAttribute("path", null);
        this._attributePath = new ArrayList<String>();
        for (Configuration attrConf : configuration.getChildren("attribute")) {
            this._attributePath.add(attrConf.getAttribute("path"));
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    public void initialize() throws ConfigurationException {
        ElementDefinition elmtDef;
        ModelItem modelItem;
        RepeaterDefinition repeaterDef;
        Object object;
        super.initialize();
        ContentType contentType = this.getContentType();
        if (!contentType.hasModelItem(this._repeaterPath) || !((object = contentType.getModelItem(this._repeaterPath)) instanceof RepeaterDefinition)) {
            throw new ConfigurationException("The repeater path '" + this._repeaterPath + "' does not point to a valid repeater in content type '" + contentType.getId() + "' for RepeaterDistributionValidator validator.");
        }
        this._repeaterDef = repeaterDef = (RepeaterDefinition)object;
        if (this._attributePath.isEmpty()) {
            throw new ConfigurationException("At least one weight attribute must be defined for RepeaterDistributionValidator validator.");
        }
        for (String attributePath : this._attributePath) {
            ElementDefinition elmtDef2;
            ModelItem modelItem2;
            if (repeaterDef.hasModelItem(attributePath) && (modelItem2 = repeaterDef.getModelItem(attributePath)) instanceof ElementDefinition && (elmtDef2 = (ElementDefinition)modelItem2).getType().getId().equals("double")) continue;
            throw new ConfigurationException("The weight attribute '" + attributePath + "' does not point to a valid double attribute in the repeater '" + this._repeaterPath + "' for RepeaterDistributionValidator validator.");
        }
        if (!(this._percentagePath == null || contentType.hasModelItem(this._percentagePath) && (modelItem = contentType.getModelItem(this._percentagePath)) instanceof ElementDefinition && (elmtDef = (ElementDefinition)modelItem).getType().getId().equals("boolean"))) {
            throw new ConfigurationException("The percentage path '" + this._percentagePath + "' does not point to a valid boolean attribute in content type '" + contentType.getId() + "' for RepeaterDistributionValidator validator.");
        }
    }

    public ValidationResult validate(Content content) {
        ValidationResult result = new ValidationResult();
        if (this._percentagePath == null || Boolean.TRUE.equals(content.getValue(this._percentagePath))) {
            for (String attributePath : this._attributePath) {
                double sum = Optional.ofNullable(content.getRepeater(this._repeaterPath)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).mapToDouble(entry -> (Double)entry.getValue(attributePath)).sum();
                if (!(sum > 100.0)) continue;
                HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
                i18nParams.put("sum", new I18nizableText(String.valueOf(sum)));
                i18nParams.put("repeaterPath", new I18nizableText(this._getRepeaterReadablePath()));
                i18nParams.put("attributeLabel", new I18nizableText(this._getAttributeLabel(attributePath)));
                result.addError(new I18nizableText("plugin.odf", "PLUGINS_ODF_CONTENT_VALIDATOR_REPEATER_DISTRIBUTION_WITH_PERCENTAGE_ERROR", i18nParams));
            }
        }
        return result;
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        List repeaterEntries;
        Optional<SynchronizableRepeater> repeater;
        Optional percentageValue;
        ValidationResult result = new ValidationResult();
        boolean weightInPercentage = this._percentagePath == null;
        Optional<Object> optional = percentageValue = this._percentagePath != null ? this._getValue(values, this._percentagePath) : Optional.empty();
        if (percentageValue.isPresent()) {
            weightInPercentage = (Boolean)((SynchronizableValue)percentageValue.get()).getValue(Optional.ofNullable(((SynchronizableValue)percentageValue.get()).getExternalizableStatus()));
        }
        if (weightInPercentage && (repeater = this._getRepeater(values, this._repeaterPath)).isPresent() && !(repeaterEntries = repeater.get().getEntries()).isEmpty()) {
            for (String attributePath : this._attributePath) {
                Double sum = repeaterEntries.stream().map(entry -> entry.get(attributePath)).filter(SynchronizableValue.class::isInstance).map(SynchronizableValue.class::cast).map(syncValue -> (Double)syncValue.getValue(Optional.ofNullable(syncValue.getExternalizableStatus()))).reduce(0.0, Double::sum);
                if (!(sum > 100.0)) continue;
                HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
                i18nParams.put("sum", new I18nizableText(String.valueOf(sum)));
                i18nParams.put("repeaterPath", new I18nizableText(this._getRepeaterReadablePath()));
                i18nParams.put("attributeLabel", new I18nizableText(this._getAttributeLabel(attributePath)));
                result.addError(new I18nizableText("plugin.odf-orientation-data", "PLUGINS_ODF_CONTENT_VALIDATOR_REPEATER_DISTRIBUTION_WITH_PERCENTAGE_ERROR", i18nParams));
            }
        }
        return result;
    }

    private String _getRepeaterReadablePath() {
        ArrayList<I18nizableText> labels = new ArrayList<I18nizableText>();
        labels.add(this._repeaterDef.getLabel());
        for (ModelItemGroup parent = this._repeaterDef.getParent(); parent != null; parent = parent.getParent()) {
            labels.add(parent.getLabel());
        }
        return labels.reversed().stream().map(label -> this._i18nUtils.translate((I18nizable)label)).collect(Collectors.joining(" > "));
    }

    private String _getAttributeLabel(String attributePath) {
        I18nizableText label = this._repeaterDef.getModelItem(attributePath).getLabel();
        return this._i18nUtils.translate((I18nizable)label);
    }

    private Optional<SynchronizableRepeater> _getRepeater(Map<String, Object> values, String repeaterPath) {
        if (values == null) {
            return Optional.empty();
        }
        String firstSegment = StringUtils.substringBefore((String)repeaterPath, (String)"/");
        Object value = values.get(firstSegment);
        if (value == null || value instanceof UntouchedValue) {
            return Optional.empty();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return this._getRepeater(map, StringUtils.substringAfter((String)repeaterPath, (String)"/"));
        }
        if (value instanceof SynchronizableRepeater) {
            SynchronizableRepeater syncRepeater = (SynchronizableRepeater)value;
            return Optional.ofNullable(syncRepeater);
        }
        throw new IllegalArgumentException("Expected value is not a synchronizable repeater");
    }

    private Optional<SynchronizableValue> _getValue(Map<String, Object> values, String attributePath) {
        if (values == null) {
            return Optional.empty();
        }
        String firstSegment = StringUtils.substringBefore((String)attributePath, (String)"/");
        Object value = values.get(firstSegment);
        if (value == null || value instanceof UntouchedValue) {
            return Optional.empty();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return this._getValue(map, StringUtils.substringAfter((String)attributePath, (String)"/"));
        }
        if (value instanceof SynchronizableValue) {
            SynchronizableValue syncValue = (SynchronizableValue)value;
            return Optional.ofNullable(syncValue);
        }
        throw new IllegalArgumentException("Expected value is not a synchronizable value");
    }
}

