/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odforientation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.search.advanced.AbstractTreeNode;
import org.ametys.cms.search.advanced.TreeLeaf;
import org.ametys.core.util.LambdaUtils;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstanceManager;
import org.ametys.web.frontoffice.search.metamodel.impl.ContentReferencingSearchServiceCriterionDefinition;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OdfReferenceTableItemsGenerator
extends ServiceableGenerator {
    private AmetysObjectResolver _resolver;
    private SearchServiceInstanceManager _searchServiceInstanceManager;
    private OdfReferenceTableHelper _odfReferenceTableHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._searchServiceInstanceManager = (SearchServiceInstanceManager)serviceManager.lookup(SearchServiceInstanceManager.ROLE);
        this._odfReferenceTableHelper = (OdfReferenceTableHelper)serviceManager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String lang = this.parameters.getParameter("lang", (String)request.getAttribute("sitemapLanguage"));
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        String refTableId = (String)zoneItem.getServiceParameters().getValue("refTableId");
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"items");
        List items = this._odfReferenceTableHelper.getItems(refTableId, false, new OdfReferenceTableHelper.SortField[]{new OdfReferenceTableHelper.SortField("order", true)});
        items.stream().forEach(LambdaUtils.wrapConsumer(e -> {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", e.getId());
            attrs.addCDATAAttribute("code", e.getCode());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"item", (Attributes)attrs, (String)e.getLabel(lang));
        }));
        this._saxSearchForm(zoneItem, refTableId);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"items");
        this.contentHandler.endDocument();
    }

    private void _saxSearchForm(ZoneItem zoneItem, String refTableId) throws SAXException {
        String criterionInputName = this._getRefTableCriterionInputName(zoneItem, refTableId);
        if (criterionInputName != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"search-form");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"criterion", (String)criterionInputName);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"search-form");
        }
    }

    private String _getRefTableCriterionInputName(ZoneItem zoneItem, String refTableId) {
        Optional<ZoneItem> searchZoneItem;
        Page page;
        String searchPageId = (String)zoneItem.getServiceParameters().getValue("search-page");
        if (StringUtils.isNotEmpty((CharSequence)searchPageId) && (page = (Page)this._resolver.resolveById(searchPageId)).getType() == Page.PageType.CONTAINER && (searchZoneItem = page.getZones().stream().flatMap(z -> z.getZoneItems().stream()).filter(zi -> zi.getType() == ZoneItem.ZoneType.SERVICE).filter(zi -> zi.getServiceId().equals("org.ametys.web.service.SearchService")).findFirst()).isPresent()) {
            SearchServiceInstance serviceInstance = this._searchServiceInstanceManager.get(searchZoneItem.get().getId());
            return serviceInstance.getCriterionTree().map(AbstractTreeNode::getFlatLeaves).orElseGet(Collections::emptyList).stream().map(TreeLeaf::getValue).filter(c -> c.getCriterionDefinition() instanceof ContentReferencingSearchServiceCriterionDefinition && ((ContentReferencingSearchServiceCriterionDefinition)c.getCriterionDefinition()).getContentTypeId().equals(refTableId)).findFirst().map(c -> c.getName()).orElseGet(null);
        }
        this.getLogger().warn("No criteria found related to selected reference table '" + refTableId + "'");
        return null;
    }
}

