/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odforientation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.search.advanced.AbstractTreeNode;
import org.ametys.cms.search.advanced.TreeLeaf;
import org.ametys.core.util.LambdaUtils;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstanceManager;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OrgUnitsGenerator
extends ServiceableGenerator {
    private AmetysObjectResolver _resolver;
    private RootOrgUnitProvider _rootOrgUnitProvider;
    private ContentTypesHelper _cTypeHelper;
    private SearchServiceInstanceManager _searchServiceInstanceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._rootOrgUnitProvider = (RootOrgUnitProvider)serviceManager.lookup(RootOrgUnitProvider.ROLE);
        this._cTypeHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._searchServiceInstanceManager = (SearchServiceInstanceManager)serviceManager.lookup(SearchServiceInstanceManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String lang = this.parameters.getParameter("lang", (String)request.getAttribute("sitemapLanguage"));
        Locale defaultLocale = LocaleUtils.toLocale((String)lang);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        String contentView = (String)zoneItem.getServiceParameters().getValue("contentView");
        View view = this._cTypeHelper.getView(contentView, new String[]{"org.ametys.plugins.odf.Content.orgunit"}, new String[0]);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgunits");
        ContentTypeExpression expr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.orgunit"});
        String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:orgunitContent", (Expression)expr);
        AmetysObjectIterable orgUnits = this._resolver.query(xPathQuery);
        List<String> excludedOrgunits = Arrays.asList((String[])zoneItem.getServiceParameters().getValue("excludedOrgunits"));
        orgUnits.stream().filter(ou -> !this._rootOrgUnitProvider.isRoot(ou) && !excludedOrgunits.contains(ou.getId())).forEach(LambdaUtils.wrapConsumer(ou -> {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", ou.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgunit", (Attributes)attrs);
            ou.dataToSAX(this.contentHandler, (ViewItemAccessor)view, DataContext.newInstance().withLocale(defaultLocale).withEmptyValues(false));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgunit");
        }));
        this._saxSearchForm(zoneItem);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgunits");
        this.contentHandler.endDocument();
    }

    private void _saxSearchForm(ZoneItem zoneItem) throws SAXException {
        String criterionInputName = this._getOrgUnitCriterionInputName(zoneItem);
        if (criterionInputName != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"search-form");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"criterion", (String)criterionInputName);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"search-form");
        }
    }

    private String _getOrgUnitCriterionInputName(ZoneItem zoneItem) {
        Optional<ZoneItem> searchZoneItem;
        Page page;
        String searchPageId = (String)zoneItem.getServiceParameters().getValue("search-page");
        if (StringUtils.isNotEmpty((CharSequence)searchPageId) && (page = (Page)this._resolver.resolveById(searchPageId)).getType() == Page.PageType.CONTAINER && (searchZoneItem = page.getZones().stream().flatMap(z -> z.getZoneItems().stream()).filter(zi -> zi.getType() == ZoneItem.ZoneType.SERVICE).filter(zi -> zi.getServiceId().equals("org.ametys.web.service.SearchService")).findFirst()).isPresent()) {
            SearchServiceInstance serviceInstance = this._searchServiceInstanceManager.get(searchZoneItem.get().getId());
            return serviceInstance.getCriterionTree().map(AbstractTreeNode::getFlatLeaves).orElseGet(Collections::emptyList).stream().map(TreeLeaf::getValue).filter(c -> StringUtils.endsWith((CharSequence)c.getCriterionDefinition().getName(), (CharSequence)"$org.ametys.plugins.odf.Content.abstractProgram$orgUnit")).findFirst().map(c -> c.getName()).orElseGet(null);
        }
        return null;
    }
}

