// /src/ressources/components/header/header.js
(function () {
  function boot() {
    try {
      initMenu();
      initTopBar();
      initMenuMobile();
      initSearchBar();
	  
	  window.addEventListener("resize", () => {
          initTopBar();
      });
	 
    } catch (e) {
      console.warn(e.message);
    }
  }

  function initSearchBar() {
    const searchForm = document.querySelector(".search__form__fixed");
    const searchInput = document.querySelector(".search__input");
    const overlaySearch = document.querySelector(".overlay-search");
    searchInput?.addEventListener("click", () => {
      searchForm.classList.add("open");
      overlaySearch.classList.add("open");
    });

    overlaySearch?.addEventListener("click", () => {
      searchForm.classList.remove("open");
      overlaySearch.classList.remove("open");
    });

  }

  function initTopBar() {
    const topBar = document.querySelector(".top-links__dropdown");
    const windowWidth = window.innerWidth;
    const isMobile = windowWidth < 750.02;

    if (isMobile) {
      topBar?.removeAttribute("open");
    } else {
      topBar?.setAttribute("open", "");
    }
  }
  
  function initMenuMobile() {
    const menuDesktopToCopy = document.querySelector(".main-bar__nav");
    const menuMobileContainer = document.querySelector(".mobile-menu");
    const menuMobile = document.querySelector(".mobile-menu__content");
    const hamburger = document.querySelector(".main-bar__hamburger .hamburger");
    const mobileMenuReturn = document.querySelector(".mobile-menu__return");
    const mobileMenuLogo = document.querySelector(".mobile-menu__logo");
	let openSubmenuInvoker = null;
	
    if (!menuDesktopToCopy || !menuMobileContainer || !menuMobile) return;

    if (menuMobileContainer.dataset.enhanced === "true") return;
    menuMobileContainer.dataset.enhanced = "true";

    menuMobile.innerHTML = menuDesktopToCopy.innerHTML;

	// Open mobile menu
	function openMobileMenu() {
		menuMobileContainer.classList.add("open");
		hamburger.setAttribute("aria-expanded", "true");
		// Trap focus into menu
		AmetysFront.Accessibility.trapFocus(menuMobileContainer, true);
		// Close menu when ESCAPE key is pressed
		menuMobileContainer.addEventListener('keydown', hideMobileMenuOnEscape);
		currentOpenLevel = 1;
	}
	
	// Close mobile menu
	function closeMobileMenu() {
		// Close all opened submenus
		menuMobileContainer.querySelectorAll('[role="dialog"]').forEach((submenu) => {
			submenu.classList.remove("open");
		})
		menuMobileContainer.querySelectorAll('[aria-expanded="true"]').forEach((btn) => {
	      btn.setAttribute("aria-expanded", "false");
	    });
		// Close mobile menu
		menuMobileContainer.classList.remove("open");
		hamburger.setAttribute("aria-expanded", "false");
		// Untrap focus into menu
		AmetysFront.Accessibility.untrapFocus(menuMobileContainer);
		menuMobileContainer.removeEventListener('keydown', hideMobileMenuOnEscape);
		// Focus open menu button
		hamburger.focus();
	}
	
	// Hide mobile menu when ESCAPE key is pressed
	function hideMobileMenuOnEscape(event) {
		if (event.key === 'Escape' || event.key === 'Esc') {
			closeMobileMenu();
		}
	}
	
	// Open mobile level
	function openSubmenuMobile(btn) {
		const controls = btn.getAttribute("aria-controls");
		
		const submenuMobile = controls
          ? menuMobile.querySelector(`#${controls}`)
          : null;
        if (!submenuMobile) return;
		
		currentSubmenu = submenuMobile;
		
		currentSubmenu.classList.add("open");
		btn.setAttribute("aria-expanded", "true");
		
		// Trap focus into submenu
		AmetysFront.Accessibility.trapFocus(currentSubmenu, true);
		
		openSubmenuInvoker = btn;
	}
	
	// Close mobile level
	function closeSubmenuMobile(btn) {
		btn.closest('.open').classList.remove("open");
		
		// Untrap focus into submenu
		AmetysFront.Accessibility.untrapFocus(currentSubmenu);
		currentSubmenu.removeAttribute("role");
		currentSubmenu.removeAttribute("aria-modal");
				
		// Focus open menu invoker
		openSubmenuInvoker?.focus();
		openSubmenuInvoker?.setAttribute("aria-expanded", "false");
		
		currentSubmenu = openSubmenuInvoker?.closest('[role="dialog"]');
		AmetysFront.Accessibility.trapFocus(currentSubmenu, false);
		
		openSubmenuInvoker = null;
	}
	
	// Bind hamburger button to open mobile menu
    hamburger?.addEventListener("click", openMobileMenu);
	
	// Bind close menu buttons
	const closeBtns = menuMobileContainer.querySelectorAll(".mobile-menu__close");
	closeBtns.forEach((btn) => {
		btn.addEventListener("click", () => {
			closeMobileMenu(btn);
		});
	});

	// Bind submenu open buttons
	const buttons = menuMobileContainer.querySelectorAll("button.menubtn, .open-submenu-mobile");
	buttons.forEach((btn) => {
		btn.setAttribute("aria-expanded", "false");
		btn.setAttribute("aria-haspopup", "true");
    	btn.addEventListener("click", () => {
			openSubmenuMobile(btn);
	 	})
	});
	
	// Bind submenu back buttons
	const backButtons = menuMobileContainer.querySelectorAll(".mobile-menu__return");
	backButtons.forEach((btn) => {
        btn.addEventListener("click", () => {
			closeSubmenuMobile(btn);
		});
	});
	
	const subMenus = menuMobile.querySelectorAll(".submenu, .subsubmenu");
	subMenus.forEach((submenu) => {
		submenu.setAttribute("role", "dialog");
		submenu.setAttribute("aria-modal", "true");
	});
  }


  function initMenu() {
    const menu = document.getElementById("main-menu");
    if (!menu) return;

    const items = menu.querySelectorAll(".has-submenu");
    const triggers = menu.querySelectorAll(".has-submenu > .menubtn");

    function closeAll(except = null) {
      items.forEach((li) => {
        const btn = li.querySelector("button.menubtn");
		if (!btn) return;
        const panel = document.getElementById(
          btn.getAttribute("aria-controls")
        );
        if (li !== except) {
          btn.setAttribute("aria-expanded", "false");
          panel.hidden = true;
          li.dataset.open = "false";
        }
      });
    }

    function open(li) {
      const btn = li.querySelector("button.menubtn");
      const panel = document.getElementById(btn.getAttribute("aria-controls"));
      btn.setAttribute("aria-expanded", "true");
      panel.hidden = false;
      li.dataset.open = "true";
    }

    triggers.forEach((btn) => {
      btn.addEventListener("click", () => {
        const li = btn.closest(".has-submenu");
        const expanded = btn.getAttribute("aria-expanded") === "true";
        expanded ? closeAll() : (closeAll(), open(li));
      });

      btn.addEventListener("keydown", (e) => {
        const li = btn.closest(".has-submenu");
        const panel = document.getElementById(
          btn.getAttribute("aria-controls")
        );
        const firstItem = panel.querySelector('a[role="menuitem"]');

        if (e.key === "Enter" || e.key === " ") {
          e.preventDefault();
          const expanded = btn.getAttribute("aria-expanded") === "true";
          expanded ? closeAll() : (closeAll(), open(li), firstItem?.focus());
        } else if (e.key === "ArrowDown") {
          e.preventDefault();
          if (btn.getAttribute("aria-expanded") !== "true") open(li);
          firstItem?.focus();
        } else if (e.key === "ArrowUp") {
          e.preventDefault();
          if (btn.getAttribute("aria-expanded") !== "true") open(li);
          const links = panel.querySelectorAll('a[role="menuitem"]');
          links[links.length - 1]?.focus();
        } else if (e.key === "Escape") {
          closeAll();
          btn.focus();
        } else if (e.key === "ArrowRight" || e.key === "ArrowLeft") {
          e.preventDefault();
          const list = Array.from(triggers);
          const idx = list.indexOf(btn);
          const next =
            e.key === "ArrowRight"
              ? list[(idx + 1) % list.length]
              : list[(idx - 1 + list.length) % list.length];
          closeAll();
          next.focus();
        }
      });
    });

    menu.addEventListener("keydown", (e) => {
      const link = e.target.closest(
        '.submenu a[role="menuitem"], .submenu__cta a[role="menuitem"]'
      );
      if (!link) return;

      const container = link.closest(".submenu, .submenu__cta");
      if (!container) return;

      const submenu = container.closest(".submenu") || container;

      const links = Array.from(submenu.querySelectorAll('a[role="menuitem"]'));
      const i = links.indexOf(link);

      const parentBtn = menu.querySelector(
        `.menubtn[aria-controls="${submenu.id}"]`
      );

      if (e.key === "ArrowDown") {
        e.preventDefault();
        (links[i + 1] || links[0])?.focus();
      } else if (e.key === "ArrowUp") {
        e.preventDefault();
        (links[i - 1] || links[links.length - 1])?.focus();
      } else if (e.key === "Home") {
        e.preventDefault();
        links[0]?.focus();
      } else if (e.key === "End") {
        e.preventDefault();
        links[links.length - 1]?.focus();
      } else if (e.key === "Escape") {
        e.preventDefault();
        closeAll();
        parentBtn?.focus();
      } else if (e.key === "ArrowLeft" || e.key === "ArrowRight") {
        e.preventDefault();
        const list = Array.from(
          document.querySelectorAll(".has-submenu > .menubtn")
        );
        const idx = list.indexOf(parentBtn);
        const next =
          e.key === "ArrowRight"
            ? list[(idx + 1) % list.length]
            : list[(idx - 1 + list.length) % list.length];
        closeAll();
        next?.focus();
      }
    });

    document.addEventListener("click", (e) => {
      const insideSubmenu = !!e.target.closest(".submenu");
      const insideSubmenuCta = !!e.target.closest(".submenu__cta");
      const onMenuBtn = !!e.target.closest(".menubtn");

      if (!insideSubmenu && !insideSubmenuCta && !onMenuBtn) {
        closeAll();
      }
    });
    /* menu.addEventListener("focusout", () => {
      setTimeout(() => {
        if (!menu.contains(document.activeElement)) closeAll();
      }, 0);
    }); */
  }

  AmetysFront.Event.listen('dom:ready', boot);
})();
