/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Carousel component
 */
Carousel = {
	
	// Default labels (i18n)
	NAV_PREV_LABEL: "{{i18n SKIN_CAROUSEL_NAV_PREV}}",
	NAV_NEXT_LABEL: "{{i18n SKIN_CAROUSEL_NAV_NEXT}}",
	DOTS_PREFIX_LABEL: "{{i18n SKIN_CAROUSEL_NAV_SLIDE_PREFIX}}",
	REGION_LABEL: "{{i18n SKIN_CAROUSEL_REGION_LABEL}}",
	
	/**
	 * Initialize the carousel
	 * @param selector the selector of the carousel container
	 * @param opts the options to customize the carousel
	 *        - slidesToShow : number of slides to show (default 4)
	 *        - slidesToScroll : number of slides to scroll (default 4)
	 *        - ametysDotsBtnPrefixLabel : prefix label for dots buttons (default from DOTS_PREFIX_LABEL)
	 *        - regionLabel : label for the carousel region (default from REGION_LABEL)
	 *        - responsive : responsive settings (default set of 3 breakpoints)
	 */
	initialize: function(selector, opts) {
		$j(`${selector} [data-carousel]`).slick({
            regionLabel: opts.regionLabel || Carousel.REGION_LABEL,
            infinite: true,

            slidesToShow: opts.slidesToShow || 4,
            slidesToScroll: opts.slidesToScroll || 4,
            ametysDotsBtnPrefixLabel : opts.ametysDotsBtnPrefixLabel || Carousel.DOTS_PREFIX_LABEL,
            
            dots: true,
            appendDots: $j(`${selector} [data-carousel-nav]`),
            
            arrows: true,
            appendArrows: $j(`${selector} [data-carousel-nav]`),
            prevArrow: `
                <button type="button" class="slick-prev">
		            <svg xmlns="http://www.w3.org/2000/svg" width="8" height="14" viewBox="0 0 8 14" fill="none">
		              <path d="M7 1L2 7L7 13" stroke="#153477" stroke-width="2"/>
		              <path d="M7 1L2 7L7 13" stroke="url(#paint0_linear_5562_6415)" stroke-width="2"/>
		              <defs>
		                <linearGradient id="paint0_linear_5562_6415" x1="7" y1="7" x2="2" y2="7" gradientUnits="userSpaceOnUse">
		                  <stop stop-color="white" stop-opacity="0.8"/>
		                  <stop offset="1" stop-color="white" stop-opacity="0.8"/>
		                </linearGradient>
		              </defs>
		            </svg>
					<span class="slick-sr-only">${Carousel.NAV_PREV_LABEL}</span>
                </button>
              `,
                    nextArrow: `
                <button type="button" class="slick-next">
	            	<svg xmlns="http://www.w3.org/2000/svg" width="8" height="14" viewBox="0 0 8 14" fill="none">
	              		<path d="M1 13L6 7L0.999999 1" stroke="#521C7E" stroke-width="2"/>
	            	</svg>
					<span class="slick-sr-only">${Carousel.NAV_NEXT_LABEL}</span>
                </button>
              `,

			  responsive: opts.responsive || [
	            {
	              breakpoint: 1200,
	              settings: {
	                slidesToShow: 3,
	                slidesToScroll: 3,
	              },
	            },
	            {
	              breakpoint: 700,
	              settings: {
	                slidesToShow: 2,
	                slidesToScroll: 2,
	              },
	            },
	            {
	              breakpoint: 500,
	              settings: {
	                slidesToShow: 1,
	                slidesToScroll: 1,
	              },
	            }
	          ]
        });
	}
}


