function updateProgressBar(progress) {
  const value = parseFloat(progress.value) || 0;
  const max = parseFloat(progress.max) || 100;
  const percentage = (value / max) * 100;

  const progressWrap = progress.closest('.progress-wrap');
  const progressText = progressWrap?.querySelector('.progress-text');

  if (progressText) {
    progressText.style.setProperty('--progress-width', `${percentage}%`);
  }
}

function initProgressBars() {
  const progressBars = document.querySelectorAll('.progress-wrap progress');

  progressBars.forEach(progress => {
    updateProgressBar(progress);

    setTimeout(() => updateProgressBar(progress), 100);
  });

  window.addEventListener('resize', () => {
    progressBars.forEach(updateProgressBar);
  });
}

AmetysFront.Event.listen('dom:ready', initProgressBars);

const observer = new MutationObserver((mutations) => {
  let shouldUpdate = false;

  mutations.forEach((mutation) => {
    mutation.addedNodes.forEach((node) => {
      if (node.nodeType === 1) {
        if (node.matches('.progress-wrap progress') ||
            node.querySelector('.progress-wrap progress')) {
          shouldUpdate = true;
        }
      }
    });
  });

  if (shouldUpdate) {
    initProgressBars();
  }
});

observer.observe(document.body, {
  childList: true,
  subtree: true
});
