(function () {

  function boot() {
    try {
		const openBtnCarousel = document.querySelector(".carousel-popup__btn");
		const popupCarousel = document.querySelector(".carousel-popup");
		const closeBtnCarousel = popupCarousel?.querySelector(".carousel-popup__close");
		
		function openPopupCarousel() {
		
		  popupCarousel.setAttribute("aria-hidden", "false");
		  popupCarousel.style.display = "block";
		  
		  AmetysFront.Accessibility.trapFocus(popupCarousel);
		
		  document.addEventListener("keydown", handleEscCarousel);
		}
		
		function closePopupCarousel() {
		  popupCarousel.setAttribute("aria-hidden", "true");
		  popupCarousel.style.display = "none";
		  
		  AmetysFront.Accessibility.untrapFocus(popupCarousel);
		  
		  document.removeEventListener("keydown", handleEscCarousel);
		  openBtnCarousel.focus();
		}
		
		function handleEscCarousel(e) {
		  if (e.key === "Escape") {
		    closePopupCarousel();
		  }
		}
		
		if (openBtnCarousel && closeBtnCarousel && popupCarousel) 
		{
			openBtnCarousel.addEventListener("click", openPopupCarousel);
			closeBtnCarousel.addEventListener("click", closePopupCarousel);
		}

    } catch (e) {
      console.warn("Carousel not initialized " + e.message);
    }
  }

  AmetysFront.Event.listen('dom:ready', boot);
})();
