(function () {
	function boot() {
		
	  // Download menu
	  const btnDownload = document.querySelector('.btn-download');
	  const btnDownloadGroup = document.querySelector('.btn-download-group');
	  const btnDownloadDropdown = document.querySelector('.btn-download-dropdown');

	  // Parcours menu
	  const btnParcours = document.querySelector('.btn-parcours');
	  const btnParcoursGroup = document.querySelector('.btn-parcours-group');
	  const btnParcoursDropdown = document.querySelector('.btn-parcours-dropdown');

	  // Keywords dropdown
	  const btnKeywords = document.querySelector('.more-keyword');
	  const keywordsDropdownGroup = document.querySelector('.keywords-dropdown-group');
	  const keywordsDropdown = document.querySelector('.keywords-dropdown');
		  
	  const closeAllDropdowns = () => {
      
		btnDownloadGroup?.classList.remove('active');
		btnParcoursGroup?.classList.remove('active');
		keywordsDropdownGroup?.classList.remove('active');
		
		btnParcours?.setAttribute('aria-expanded', 'false');
		btnKeywords?.setAttribute('aria-expanded', 'false');
		btnDownload?.setAttribute('aria-expanded', 'false');
		
		keywordsDropdown?.setAttribute('aria-hidden', 'true');
		btnParcoursDropdown?.setAttribute('aria-hidden', 'true');
		btnDownloadDropdown?.setAttribute('aria-hidden', 'true');
      };
	  
	  if (btnDownload && btnDownloadGroup) {
	      btnDownload.addEventListener('click', (e) => {
	        e.stopPropagation();
	        const isActive = btnDownloadGroup.classList.contains('active');

	        closeAllDropdowns();

	        if (!isActive) {
	          btnDownloadGroup.classList.add('active');
	        }
	      });
	    }

	    if (btnParcours && btnParcoursGroup) {
	      btnParcours.addEventListener('click', (e) => {
	        e.stopPropagation();
	        const isActive = btnParcoursGroup.classList.contains('active');

	        closeAllDropdowns();

	        if (!isActive) {
	          btnParcoursGroup.classList.add('active');
	          btnParcours.setAttribute('aria-expanded', 'true');
	          if (btnParcoursDropdown) {
	            btnParcoursDropdown.setAttribute('aria-hidden', 'false');
	          }
	        }
	      });
	    }

	    if (btnKeywords && keywordsDropdownGroup) {
	      btnKeywords.addEventListener('click', (e) => {
	        e.stopPropagation();
	        const isActive = keywordsDropdownGroup.classList.contains('active');

	        closeAllDropdowns();

	        if (!isActive) {
	          keywordsDropdownGroup.classList.add('active');
	          btnKeywords.setAttribute('aria-expanded', 'true');
	          if (keywordsDropdown) {
	            keywordsDropdown.setAttribute('aria-hidden', 'false');
	          }
	        }
	      });
	    }

	    document.addEventListener('click', (e) => {
	      closeAllDropdowns();
	    });

      btnDownloadDropdown?.addEventListener('click', (e) => {
        e.stopPropagation();
      });

      btnParcoursDropdown?.addEventListener('click', (e) => {
        e.stopPropagation();
      });

      keywordsDropdown?.addEventListener('click', (e) => {
        e.stopPropagation();
      });
		
	}
	
	AmetysFront.Event.listen('dom:ready', boot);
})();
