(function () {
  function boot() {
    try {
      initFormationNav();
    } catch (e) {
      console.warn(e.message);
    }
  }

  function initFormationNav() {
    const nav = document.querySelector(".nav-formation");
    if (!nav) return;

    const links = nav.querySelectorAll("a[href^='#']");
    const sections = Array.from(links)
      .map((link) => document.querySelector(link.getAttribute("href")))
      .filter(Boolean);

    // Calcule et applique le top pour sticky
    function updateStickyTop() {
      const header = document.querySelector(".header");
      if (header) {
        const heightHeader = header.offsetHeight;
        nav.style.top = `${heightHeader}px`;
      }
    }

    links.forEach((link) => {
      link.addEventListener("click", (e) => {
        e.preventDefault();
        const targetId = link.getAttribute("href");
        const targetSection = document.querySelector(targetId);
        if (!targetSection) return;
        const navHeight = nav.offsetHeight;

        window.scrollTo({
          top: targetSection.offsetTop - navHeight - 120,
          behavior: "smooth",
        });
		
		targetSection.setAttribute("tabindex", "-1");
		targetSection.focus();
      });
    });

    function updateAriaCurrent() {
      let current = null;

      sections.forEach((section) => {
        const rect = section.getBoundingClientRect();
        if (
          rect.top <= window.innerHeight * 0.3 &&
          rect.bottom >= window.innerHeight * 0.3
        ) {
          current = section;
        }
      });

      links.forEach((link) => {
        if (current && link.getAttribute("href") === `#${current.id}`) {
          link.setAttribute("aria-current", "step");
        } else {
          link.removeAttribute("aria-current");
        }
      });
    }

    // Initialisation
    updateStickyTop();
    updateAriaCurrent();

    // Écoute uniquement le scroll pour aria-current (plus léger)
    window.addEventListener("scroll", updateAriaCurrent);

    // Recalcule le top au resize
    window.addEventListener("resize", updateStickyTop);
  }

  AmetysFront.Event.listen('dom:ready', boot);
})();
