(function () {
  function boot() {
    try {

	const openBtnNews = document.querySelector(".news-popup__btn");
	const popupNews = document.querySelector(".news-popup");
	const closeBtnNews = popupNews.querySelector(".news-popup__close");
	
	function openPopupNews() {
	  popupNews.setAttribute("aria-hidden", "false");
	  popupNews.style.display = "block";
	
	  AmetysFront.Accessibility.trapFocus(popupNews, true);
	
	  document.addEventListener("keydown", trapFocusNews);
	  document.addEventListener("keydown", handleEscNews);
	}
	
	function closePopupNews() {
	  popupNews.setAttribute("aria-hidden", "true");
	  popupNews.style.display = "none";
	
	  AmetysFront.Accessibility.untrapFocus(popupNews);
	
	  document.removeEventListener("keydown", handleEscNews);
	  openBtnNews.focus();
	}
	
	function handleEscNews(e) {
	  if (e.key === "Escape") {
	    closePopupNews();
	  }
	}
	
	openBtnNews?.addEventListener("click", openPopupNews);
	closeBtnNews?.addEventListener("click", closePopupNews);


    } catch (e) {
      console.warn(e.message);
    }
  }

  AmetysFront.Event.listen('dom:ready', boot);
})();
