(function () {
  function boot() {
    try {
      	// Initialize the carousel for others formations
		Carousel.initialize('.others-formations', {
            slidesToShow: 4,
            slidesToScroll: 4,
			responsive: [
		          {
		            breakpoint: 1480,
		            settings: {
		              slidesToShow: 4,
		              slidesToScroll: 4,
		            },
		          },
		          {
		            breakpoint: 950,
		            settings: {
		              slidesToShow: 3,
		              slidesToScroll: 3,
		            },
		          },
		          {
		            breakpoint: 750,
		            settings: {
		              slidesToShow: 2,
		              slidesToScroll: 2,
		            },
		          },
		          {
		            breakpoint: 500,
		            settings: {
		              slidesToShow: 1,
		              slidesToScroll: 1,
		            },
		          },
		        ],
          });

		const openBtnOthersFormations = document.querySelector(".others-formations-popup__btn");
		const popupOthersFormations = document.querySelector(".others-formations-popup");
		const closeBtnOthersFormations = document.querySelector(".others-formations-popup__close");
		
		function openPopupOthersFormations() {
		  popupOthersFormations.attr("aria-hidden", "false");
		  popupOthersFormations.show()
		
		  AmetysFront.Accessibility.trapFocus(popupOthersFormations);
		  
		  document.addEventListener("keydown", handleEscOthersFormations);
		}
		
		function closePopupOthersFormations() {
		  popupOthersFormations.attr("aria-hidden", "true");
		  popupOthersFormations.hide();
		
		  AmetysFront.Accessibility.untrapFocus(popupOthersFormations);
		
		  document.removeEventListener("keydown", handleEscOthersFormations);
		  openBtnOthersFormations.focus();
		}
		
		function handleEscOthersFormations(e) {
		  if (e.key === "Escape") {
		    closePopupOthersFormations();
		  }
		}
		
		openBtnOthersFormations?.addEventListener("click", openPopupOthersFormations);
		closeBtnOthersFormations?.addEventListener("click", closePopupOthersFormations);


    } catch (e) {
      console.warn(e.message);
    }
  }

  AmetysFront.Event.listen('dom:ready', boot);
})();
