function handleMobileSidebar()
{
	const mobileSidebar = document.querySelector('.search-page .sidebar');
  	const mobileFilterBtn = document.querySelector('.btn-mobile-filters');
  	const sidebarOverlay = document.querySelector('.sidebar-overlay');
	
	if (!mobileSidebar || !mobileFilterBtn) return;
	
	function openSidebar() {
		mobileSidebar.classList.add('sidebar-open');
		sidebarOverlay?.classList.add('active');
		document.body.style.overflow = 'hidden';
		
		// Focus first facet filter
		var focusableEls = mobileSidebar.querySelectorAll(".sidebar-details summary");
		focusableEls[0]?.focus();
		
		// Fermer la sidebar avec la touche Escape
		document.addEventListener('keydown', closeSidebarOnEsc);
	}
	
	function closeSidebar() {
		mobileSidebar.classList.remove('sidebar-open');
		sidebarOverlay?.classList.remove('active');
		document.body.style.overflow = '';
		
		mobileFilterBtn.focus();	
		document.removeEventListener('keydown', closeSidebarOnEsc);
	}
	
	function closeSidebarOnEsc(e) {
		if (e.key === 'Escape' && mobileSidebar.classList.contains('sidebar-open')) {
	        closeSidebar();
	    }
	}
	
	// Ouvrir la sidebar
   	mobileFilterBtn.addEventListener('click', openSidebar);
	
	// Fermer la sidebar en cliquant sur l'overlay
    sidebarOverlay?.addEventListener('click', closeSidebar);
	
	// Close sidebar when focus is outside
	mobileSidebar.addEventListener('focusout', (e) => {
		if (e.relatedTarget && !mobileSidebar.contains(e.relatedTarget) && mobileSidebar.classList.contains('sidebar-open')) {
			closeSidebar();
		}
	});
}

function handleDownloadMenu()
{
	const groups = $j('.list-results .btn-download-group');

	groups.each((index, group) => {
        const btn = group.querySelector('.btn-download');
        const menu = group.querySelector('.btn-download-dropdown');
        if (!btn || !menu) return;

        // ----- Accessibilité ARIA -----
        const menuId = `download-menu-${index}`;
        btn.setAttribute('type', 'button');
        btn.setAttribute('aria-haspopup', 'true');
        btn.setAttribute('aria-expanded', 'false');
        btn.setAttribute('aria-controls', menuId);

        menu.setAttribute('id', menuId);
        menu.setAttribute('role', 'menu');
        menu.setAttribute('aria-hidden', 'true');

        const items = menu.querySelectorAll('a');
        items.forEach(a => {
          a.setAttribute('role', 'menuitem');
          a.setAttribute('tabindex', '-1');
        });

        // ----- Fonctions -----
		const adjustMenuAlignment = () => {
        // Vérifier si on est en mobile (largeur d'écran < 768px)
        if (window.innerWidth < 768) {
          // Calculer la position du bouton par rapport à la largeur de l'écran
          const buttonRect = btn.getBoundingClientRect();
          const buttonCenter = buttonRect.left + (buttonRect.width / 2);
          const screenCenter = window.innerWidth / 2;

          // Si le bouton est plus à gauche que le centre de l'écran
          if (buttonCenter < screenCenter) {
            menu.classList.add('align-left');
          } else {
            menu.classList.remove('align-left');
          }
        } else {
          // En desktop, toujours aligner à droite
          menu.classList.remove('align-left');
        }
      };
			  
        const openMenu = () => {
		  adjustMenuAlignment();
          menu.setAttribute('aria-hidden', 'false');
          btn.setAttribute('aria-expanded', 'true');
          items[0].focus();
        };

        const closeMenu = () => {
          menu.setAttribute('aria-hidden', 'true');
          btn.setAttribute('aria-expanded', 'false');
          btn.focus();
        };

        // ----- Événements -----
		console.log("add listener on btn", btn);
        btn.addEventListener('click', (e) => {
			e.preventDefault()
          const isOpen = btn.getAttribute('aria-expanded') === 'true';
          if (isOpen) closeMenu();
          else openMenu();
        });

        // Fermer sur clic extérieur
        document.addEventListener('click', (e) => {
          if (!group.contains(e.target)) {
            if (btn.getAttribute('aria-expanded') === 'true') closeMenu();
          }
        });

        // Gestion clavier
        group.addEventListener('keydown', (e) => {
          const isOpen = btn.getAttribute('aria-expanded') === 'true';
          const currentIndex = Array.from(items).indexOf(document.activeElement);

          switch (e.key) {
            case 'Escape':
              if (isOpen) {
                e.preventDefault();
                closeMenu();
              }
              break;
            case 'ArrowDown':
              e.preventDefault();
              if (!isOpen) openMenu();
              else {
                const next = items[currentIndex + 1] || items[0];
                next.focus();
              }
              break;
            case 'ArrowUp':
              e.preventDefault();
              if (isOpen) {
                const prev = items[currentIndex - 1] || items[items.length - 1];
                prev.focus();
              }
              break;
            case 'Tab':
              // Ferme quand on sort du menu
              if (isOpen && !group.contains(document.activeElement)) {
                closeMenu();
              }
              break;
            case 'Enter':
              // Active le lien sélectionné si focusé
              if (isOpen && document.activeElement.tagName === 'A') {
                document.activeElement.click();
                closeMenu();
              }
              break;
          }
        });
		
		// Recalculer l'alignement lors du redimensionnement de la fenêtre
      window.addEventListener('resize', () => {
        if (btn.getAttribute('aria-expanded') === 'true') {
          adjustMenuAlignment();
        }
      });
  });
}

function handleVisibleFilters(maxVisible)
{
	$j('.sidebar-details').each((i, section) => {
        const list = section.querySelector('.checkbox-list');
        const btn  = section.querySelector(':scope > button.btn'); 
        if (!list || !btn) return;

        const items = Array.from(list.querySelectorAll('.checkbox-item'));
        const extra = items.slice(maxVisible);
  
        if (extra.length === 0) {
          btn.style.display = 'none';
          return;
        }

        extra.forEach(el => el.hidden = true);
        btn.dataset.state = 'collapsed';
        btn.setAttribute('aria-expanded', 'false');
        btn.textContent = '{{i18n SKIN_SERVICE_ODF_SEARCH_FACETS_SHOW_MORE}}';

        btn.addEventListener('click', () => {
          const collapsed = btn.dataset.state === 'collapsed';

          extra.forEach(el => el.hidden = !collapsed ? true : false);

          btn.dataset.state = collapsed ? 'expanded' : 'collapsed';
          btn.setAttribute('aria-expanded', collapsed ? 'true' : 'false');
          btn.textContent = collapsed ? '{{i18n SKIN_SERVICE_ODF_SEARCH_FACETS_SHOW_LESS}}' : '{{i18n SKIN_SERVICE_ODF_SEARCH_FACETS_SHOW_MORE}}';
        });
      });
}

function handleOtherSubprograms()
{
  $j('[data-read-more]').each((index, btn) => {
	
	const targetClass = btn.getAttribute('data-read-more');
	const targetEl = document.querySelector(`.${targetClass}`);
    if (!targetEl) return;
	
	const targetId = `other-subprograms-${index}`;
    btn.setAttribute('aria-expanded', 'false');
    btn.setAttribute('aria-controls', targetId);
	targetEl.setAttribute('id', targetId);
	
    btn.addEventListener('click', (e) => {
      e.preventDefault();

      const targetClass = btn.getAttribute('data-read-more');
      const targetEl = document.querySelector(`.${targetClass}`);

      if (!targetEl) return;

      targetEl.classList.toggle('full');

      if (targetEl.classList.contains('full')) {
        btn.classList.add('read-more');
		btn.setAttribute('aria-expanded', 'true');
        btn.textContent = btn.getAttribute('data-close-text');
      } else {
        btn.classList.remove('read-more');
		btn.setAttribute('aria-expanded', 'false');
        btn.textContent = btn.getAttribute('data-open-text');
      }
    });
  });
}

function initSearchResults()
{
	handleMobileSidebar()
	handleVisibleFilters(5);
    handleOtherSubprograms();
	handleDownloadMenu();
}