<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="skin://services/web/pages/services/common.xsl"/>        

    <xsl:param name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:param name="subtitle" select="ametys:serviceParameter('subtitle')/text()"/>
    <xsl:param name="searchPageId" select="ametys:serviceParameter('search-page')/text()"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="is-empty" select="count(orgunits/orgunit) = 0"/>    
    <xsl:variable name="common-service-css-class-name">service-odf-orgunits carousel</xsl:variable> 
    
    <xsl:template name="common-service-head-css">
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/js/vendor/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/js/vendor/slick/slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
        
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/carousel.css')}" type="text/css" />
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('zones/carousel/carousel.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/vendor/slick/slick.js')}"></script>
        
        <script type="text/javascript" src="{$uri-prefix}/skins/{$skin}/resources/templates/common/js/carousel.{$lang}.js"></script>
        <script type="text/javascript" src="{ametys:skinURL('zones/carousel/carousel.js')}"></script>
        <script type="text/javascript">
          $j(function(){
              Carousel.initialize('#orgunits-carousel-<xsl:value-of select="$uniqueId"/>', {
                regionLabel: "<xsl:value-of select="$header"/>",
                slidesToShow: 4,
                slidesToScroll: 4,
                responsive: [
                {
                  breakpoint: 1200,
                  settings: {
                    slidesToShow: 3,
                    slidesToScroll: 3,
                  },
                },
                {
                  breakpoint: 700,
                  settings: {
                    slidesToShow: 2,
                    slidesToScroll: 2,
                  },
                },
                {
                  breakpoint: 500,
                  settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                  },
                }
              ]
              });
          })
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>        
        </xsl:call-template>
    </xsl:template>   
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">  
        <xsl:if test="$subtitle != ''">
            <h2 class="service-subtitle">
                <xsl:call-template name="text.nl2br">
                    <xsl:with-param name="input"><xsl:value-of select="$subtitle"/></xsl:with-param>
                </xsl:call-template>
            </h2>
        </xsl:if>
        
        <div id="orgunits-carousel-{$uniqueId}">
            <div class="carousel__list" data-carousel="true">
                <xsl:apply-templates select="/orgunits/orgunit"/>
            </div>
            
            <div class="carousel-nav-wrapper" data-carousel-nav="true"></div>
            
            <xsl:call-template name="carousel-mobile"/>
        </div>
    </xsl:template>  
    
    <xsl:template name="carousel-mobile">
        <button class="carousel-popup__btn" aria-haspopup="dialog">
            <i18n:text i18n:key="SKIN_ITEMS_POPUP_OPEN" i18n:catalogue="skin.{$skin}"/>
        </button>
        
        <xsl:call-template name="carousel-popup"/>
    </xsl:template>
    
    <xsl:template name="carousel-popup">
        <div class="carousel-popup" role="dialog" aria-modal="true" aria-hidden="true" aria-labelledby="carousel-popup-title">
            <div class="container">
                
                <xsl:call-template name="carousel-popup-close"/>
                
                <h1 id="carousel-popup-title" class="service-title"><xsl:value-of select="$header"/></h1>
                <xsl:if test="$subtitle != ''">
                    <h2 class="service-subtitle">
                        <xsl:call-template name="text.nl2br">
                            <xsl:with-param name="input"><xsl:value-of select="$subtitle"/></xsl:with-param>
                        </xsl:call-template>
                    </h2>
                </xsl:if>
    
                <div class="carousel__list__popup">
                    <xsl:apply-templates select="/orgunits/orgunit"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="carousel-popup-close">
        <button class="carousel-popup__close" title="skin.{$skin}:SKIN_ITEMS_POPUP_CLOSE" i18n:attr="title">
            <svg width="35" height="35" viewBox="0 0 35 35" fill="none" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
                <rect width="35" height="35" rx="17.5" fill="#FFCC00"></rect>
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M14.459 18.3861L17.8858 21.7469L16.6081 23L11 17.5L16.6081 12L17.8858 13.2531L14.459 16.6139L24 16.6139V18.3861L14.459 18.3861Z" fill="#521C7E"></path>
            </svg>
        </button>
    </xsl:template>
    
    <xsl:template match="orgunit">
        <form action="{resolver:resolve('page', $searchPageId)}" method="POST">
            <input type="hidden" name="user.input.criterion.{/orgunits/search-form/criterion}" value="{@id}"/>
            <input type="hidden" name="submit-form"/>
            <a class="carousel__item" href="javascript:void(0)" onclick="$j(this).parent('form').submit()">
                <xsl:apply-templates select="." mode="image"/>
                <xsl:apply-templates select="." mode="title"/>
            </a>
        </form>
    </xsl:template>
    
    <xsl:template match="orgunit" mode="image">
        <xsl:param name="maxWidth">351</xsl:param>
        <xsl:param name="maxHeight">270</xsl:param>
        
        <div class="carousel__item__picture">
            <xsl:choose>
                <xsl:when test="illustration/image">
                    <xsl:variable name="image" select="illustration/image"/>
                    <picture>
                        <img src="{resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)}" alt="{illustration/alt-text}" />
                    </picture>
                </xsl:when>
                <xsl:when test="logo/image">
                    <xsl:variable name="logo" select="logo/image"/>
                    <picture>
                        <img src="{resolver:resolveCroppedImage($logo/@type, $logo/@uri, $maxHeight, $maxWidth)}" alt="{logo/alt-text}" />
                    </picture>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="orgunit-item-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="orgunit" mode="title">
        <div class="carousel__item__content">
            <span><xsl:value-of select="title"/></span>
        </div>
    </xsl:template>
    
    <xsl:template name="orgunit-item-default-image">
        <img src="{ametys:skinURL('zones/carousel/default.png')}" alt=""/>
    </xsl:template>
    
    
</xsl:stylesheet>